/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4174;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.builder.ItemBuilder;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.IDocumentedConfigurable;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonArmorItem;
import net.threetag.palladium.item.AddonAxeItem;
import net.threetag.palladium.item.AddonBlockItem;
import net.threetag.palladium.item.AddonBowItem;
import net.threetag.palladium.item.AddonCrossbowItem;
import net.threetag.palladium.item.AddonHoeItem;
import net.threetag.palladium.item.AddonItem;
import net.threetag.palladium.item.AddonPickaxeItem;
import net.threetag.palladium.item.AddonProjectileItem;
import net.threetag.palladium.item.AddonShieldItem;
import net.threetag.palladium.item.AddonShovelItem;
import net.threetag.palladium.item.AddonSwordItem;
import net.threetag.palladium.item.FluxCapacitorItem;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.power.ability.AttributeModifierAbility;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.registry.CreativeModeTabRegistry;
import net.threetag.palladiumcore.util.Platform;

public class ItemParser
extends AddonParser<class_1792> {
    public static final class_2960 FALLBACK_SERIALIZER = Palladium.id("default");
    private static final Map<class_2960, ItemTypeSerializer> TYPE_SERIALIZERS = new LinkedHashMap<class_2960, ItemTypeSerializer>();
    public final Map<class_2960, List<PlacedTabPlacement>> autoRegisteredBlockItems = new HashMap<class_2960, List<PlacedTabPlacement>>();

    public ItemParser() {
        super(GSON, "items", class_7924.field_41197);
    }

    @Override
    public void injectJsons(Map<class_2960, JsonElement> map) {
        for (class_2960 id : this.autoRegisteredBlockItems.keySet()) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "palladium:block_item");
            json.addProperty("block", id.toString());
            JsonArray jsonArray = new JsonArray();
            if (this.autoRegisteredBlockItems.get(id) != null) {
                for (PlacedTabPlacement tabPlacement : this.autoRegisteredBlockItems.get(id)) {
                    jsonArray.add(tabPlacement.toJson());
                }
            }
            json.add("creative_mode_tab", (JsonElement)jsonArray);
            map.put(id, (JsonElement)json);
        }
    }

    @Override
    public AddonBuilder<class_1792> parse(class_2960 id, JsonElement jsonElement) {
        JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"$");
        ItemBuilder builder = new ItemBuilder(id, json);
        builder.type(GsonUtil.getAsResourceLocation(json, "type", null)).maxStackSize(GsonUtil.getAsIntRanged(json, "max_stack_size", 1, 64, 64)).maxDamage(GsonUtil.getAsIntMin(json, "max_damage", 1, 0)).rarity(ItemParser.getRarity(class_3518.method_15253((JsonObject)json, (String)"rarity", null))).fireResistant(class_3518.method_15258((JsonObject)json, (String)"is_fire_resistant", (boolean)false)).tooltipLines(GsonUtil.getAsComponentList(json, "tooltip", null)).shouldRenderModel(class_3518.method_15258((JsonObject)json, (String)"should_render_model", (boolean)true));
        GsonUtil.ifHasKey(json, "creative_mode_tab", je -> {
            for (PlacedTabPlacement placedTabPlacement : GsonUtil.fromListOrPrimitive(je, PlacedTabPlacement::fromJson)) {
                builder.creativeModeTab(placedTabPlacement);
            }
        });
        GsonUtil.ifHasKey(json, "attribute_modifiers", je -> ItemParser.parseAttributeModifiers(builder, je));
        if (Platform.isClient()) {
            GsonUtil.ifHasObject(json, "render_layers", jsonObject -> {
                IAddonItem.RenderLayerContainer container = new IAddonItem.RenderLayerContainer();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String key = (String)entry.getKey();
                    GsonUtil.forEachInListOrPrimitive((JsonElement)entry.getValue(), idElement -> container.addLayer(key, new class_2960(idElement.getAsString())));
                }
                builder.setRenderLayerContainer(container);
            });
        }
        GsonUtil.ifHasObject(json, "food", foodJson -> {
            class_4174.class_4175 properties = new class_4174.class_4175();
            GsonUtil.ifHasKey(foodJson, "nutrition", el -> properties.method_19238(class_3518.method_15257((JsonElement)el, (String)"$.food.nutrition")));
            GsonUtil.ifHasKey(foodJson, "saturation_modifier", el -> properties.method_19237(class_3518.method_15269((JsonElement)el, (String)"$.food.saturation_modifier")));
            if (class_3518.method_15258((JsonObject)foodJson, (String)"meat", (boolean)false)) {
                properties.method_19236();
            }
            if (class_3518.method_15258((JsonObject)foodJson, (String)"can_always_eat", (boolean)false)) {
                properties.method_19240();
            }
            if (class_3518.method_15258((JsonObject)foodJson, (String)"fast", (boolean)false)) {
                properties.method_19241();
            }
            GsonUtil.ifHasArray(foodJson, "effects", effectEl -> {
                JsonObject effect = class_3518.method_15295((JsonElement)effectEl, (String)"$.food.effects");
                class_2960 mobEffect = GsonUtil.getAsResourceLocation(effect, "mob_effect");
                if (!class_7923.field_41174.method_10250(mobEffect)) {
                    throw new JsonParseException("Mob effect type '" + mobEffect.toString() + "' does not exist");
                }
                int duration = class_3518.method_15282((JsonObject)effect, (String)"duration", (int)0);
                int amplifier = class_3518.method_15282((JsonObject)effect, (String)"amplifier", (int)0);
                boolean ambient = class_3518.method_15258((JsonObject)effect, (String)"ambient", (boolean)false);
                boolean visible = class_3518.method_15258((JsonObject)effect, (String)"visible", (boolean)true);
                boolean showIcon = class_3518.method_15258((JsonObject)effect, (String)"show_icon", (boolean)true);
                float probability = class_3518.method_15277((JsonObject)effect, (String)"probability", (float)1.0f);
                properties.method_19239(new class_1293(Objects.requireNonNull((class_1291)class_7923.field_41174.method_10223(mobEffect)), duration, amplifier, ambient, visible, showIcon), probability);
            });
            builder.food(properties.method_19242());
        });
        return builder;
    }

    public static HTMLBuilder documentationBuilder() {
        return new HTMLBuilder(new class_2960("palladium", "items"), "Items").add(HTMLBuilder.heading("Items")).add(HTMLBuilder.subHeading("Global Settings")).addDocumentation(ItemParser.getDefaultDocumentationBuilder()).addDocumentationSettings(new ArrayList<IDocumentedConfigurable>(TYPE_SERIALIZERS.values()));
    }

    public static class_1814 getRarity(String name) {
        for (class_1814 rarity : class_1814.values()) {
            if (!rarity.name().equalsIgnoreCase(name)) continue;
            return rarity;
        }
        return null;
    }

    public static void parseAttributeModifiers(ItemBuilder builder, JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject object = jsonElement.getAsJsonObject();
            for (String key : object.keySet()) {
                PlayerSlot slot = PlayerSlot.get(key);
                JsonElement mods = object.get(key);
                if (mods.isJsonArray()) {
                    JsonArray modsList = mods.getAsJsonArray();
                    for (JsonElement mod : modsList) {
                        builder.addAttributeModifier(slot, GsonUtil.getAsResourceLocation(mod.getAsJsonObject(), "attribute"), ItemParser.parseAttributeModifier(mod.getAsJsonObject()));
                    }
                    continue;
                }
                if (mods.isJsonObject()) {
                    builder.addAttributeModifier(slot, GsonUtil.getAsResourceLocation(mods.getAsJsonObject(), "attribute"), ItemParser.parseAttributeModifier(mods.getAsJsonObject()));
                    continue;
                }
                throw new JsonSyntaxException("Attribute modifiers definitions need to be either an object or an array");
            }
        } else {
            throw new JsonSyntaxException("The attribute modifier definition needs to be an object");
        }
    }

    public static class_1322 parseAttributeModifier(JsonObject json) {
        UUID uuid = GsonUtil.getAsUUID(json, "uuid");
        String name = class_3518.method_15253((JsonObject)json, (String)"name", (String)"Addonpack Item Modifier");
        double amount = class_3518.method_34927((JsonObject)json, (String)"amount");
        class_1322.class_1323 operation = class_1322.class_1323.method_6190((int)GsonUtil.getAsIntRanged(json, "operation", class_1322.class_1323.field_6328.method_6191(), class_1322.class_1323.field_6331.method_6191()));
        return new class_1322(uuid, name, amount, operation);
    }

    public static void registerTypeSerializer(ItemTypeSerializer serializer) {
        TYPE_SERIALIZERS.put(serializer.getId(), serializer);
    }

    public static ItemTypeSerializer getTypeSerializer(class_2960 id) {
        return TYPE_SERIALIZERS.get(id);
    }

    public static JsonDocumentationBuilder getDefaultDocumentationBuilder() {
        JsonDocumentationBuilder builder = new JsonDocumentationBuilder();
        builder.setDescription("These settings apply to ALL item types. Keep in mind that if fields are not required, you do NOT need to write them into your json.");
        builder.addProperty("type", class_2960.class).description("Item Type, each come with new different settings. Listed below on this page.").fallback(new class_2960("palladium:default"));
        builder.addProperty("max_stack_size", Integer.class).description("Max stack size for an itemstack. Range: 1-64").fallback(64).exampleJson((JsonElement)new JsonPrimitive((Number)64));
        builder.addProperty("max_damage", Integer.class).description("Max damage for an item. Must be greater then or equal 0.").fallback(0);
        builder.addProperty("creative_mode_tab", class_2960.class).description("ID of the creative mode tab the item is supposed to appear in. Fore more precise placements, check the \"Custom Items\" page on the wiki. Possible values: " + Arrays.toString(class_7923.field_44687.method_10235().stream().sorted(Comparator.comparing(class_2960::toString)).toArray())).fallback(null).exampleJson((JsonElement)new JsonPrimitive("minecraft:decorations"));
        builder.addProperty("rarity", String.class).description("Rarity of the item, influences the item name's color. Possible values: " + Arrays.toString(Arrays.stream(class_1814.values()).map(r -> r.toString().toLowerCase(Locale.ROOT)).toArray())).fallback(null).exampleJson((JsonElement)new JsonPrimitive("epic"));
        builder.addProperty("is_fire_resistant", Boolean.class).description("Whether or not the item will survive being thrown into fire/lava.").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        builder.addProperty("should_render_model", Boolean.class).description("If false, the item model will be ignored (except in the inventory). In first person, the player's arm will render instead. This allows a render layer to be applied in place of a less-dynamic item model.").fallback(true).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        JsonArray tooltipExample = new JsonArray();
        tooltipExample.add("Line 1");
        JsonObject line2 = new JsonObject();
        line2.addProperty("translate", "example.line2.translation_key");
        line2.addProperty("color", "#BCD42A");
        line2.addProperty("underlined", Boolean.valueOf(true));
        tooltipExample.add((JsonElement)line2);
        builder.addProperty("tooltip", class_2561[].class).description("Tooltip lines. Can be array of primitive strings or more complex text component").fallback(null).exampleJson((JsonElement)tooltipExample);
        JsonObject attributeModifiers = (JsonObject)class_3518.method_15284((Gson)GSON, (String)"{ \"all\": [ { \"attribute\": \"minecraft:generic.max_health\", \"amount\": 2, \"operation\": 0, \"uuid\": \"f98db25e-91cb-45ca-ba40-5526ff2cd180\" } ],\"chest\": [ { \"attribute\": \"minecraft:generic.movement_speed\", \"amount\": 4, \"operation\": 1, \"uuid\": \"3a4df804-2be2-4002-a829-eaf29a629cac\" } ] }", JsonObject.class);
        builder.addProperty("attribute_modifiers", class_1322[].class).description("Attribute modifiers when having the item equipped. You first specify the slot (\"all\" for every slot, other options: " + Arrays.toString(Arrays.stream(class_1304.values()).map(class_1304::method_5923).toArray()) + "), then an array for different modifiers. Possible attributes: " + AttributeModifierAbility.getAttributeList()).fallback(null).exampleJson((JsonElement)attributeModifiers);
        JsonObject foodExample = new JsonObject();
        foodExample.addProperty("nutrition", (Number)5);
        foodExample.addProperty("saturation_modifier", (Number)Float.valueOf(0.6f));
        foodExample.addProperty("meat", Boolean.valueOf(false));
        foodExample.addProperty("can_always_eat", Boolean.valueOf(false));
        foodExample.addProperty("fast", Boolean.valueOf(false));
        JsonArray effectsExample = new JsonArray();
        JsonObject effectExample = new JsonObject();
        effectExample.addProperty("mob_effect", Objects.requireNonNull(class_7923.field_41174.method_10221((Object)class_1294.field_5910)).toString());
        effectExample.addProperty("duration", (Number)40);
        effectExample.addProperty("amplifier", (Number)1);
        effectExample.addProperty("ambient", Boolean.valueOf(false));
        effectExample.addProperty("visible", Boolean.valueOf(true));
        effectExample.addProperty("show_icon", Boolean.valueOf(true));
        effectExample.addProperty("probability", (Number)Float.valueOf(1.0f));
        effectsExample.add((JsonElement)effectExample);
        foodExample.add("effects", (JsonElement)effectsExample);
        builder.addProperty("food", class_4174.class).description("Settings to make this item edible. The only required field in this json part is the mob_effect IF you add any effect").fallback(null).exampleJson((JsonElement)foodExample);
        return builder;
    }

    static {
        ItemParser.registerTypeSerializer(new AddonItem.Parser());
        ItemParser.registerTypeSerializer(new AddonBlockItem.Parser());
        ItemParser.registerTypeSerializer(new AddonArmorItem.Parser());
        ItemParser.registerTypeSerializer(new AddonSwordItem.Parser());
        ItemParser.registerTypeSerializer(new AddonPickaxeItem.Parser());
        ItemParser.registerTypeSerializer(new AddonAxeItem.Parser());
        ItemParser.registerTypeSerializer(new AddonShovelItem.Parser());
        ItemParser.registerTypeSerializer(new AddonHoeItem.Parser());
        ItemParser.registerTypeSerializer(new AddonShieldItem.Parser());
        ItemParser.registerTypeSerializer(new AddonBowItem.Parser());
        ItemParser.registerTypeSerializer(new AddonCrossbowItem.Parser());
        ItemParser.registerTypeSerializer(new FluxCapacitorItem.Parser());
        ItemParser.registerTypeSerializer(new AddonProjectileItem.Parser());
    }

    public static class PlacedTabPlacement {
        private final int type;
        private final class_2960 referencedItem;
        private final class_2960 tab;

        private PlacedTabPlacement(int type, class_2960 referencedItem, class_2960 tab) {
            this.type = type;
            this.referencedItem = referencedItem;
            this.tab = tab;
        }

        public class_2960 getTab() {
            return this.tab;
        }

        public static PlacedTabPlacement add(class_2960 tab) {
            return new PlacedTabPlacement(0, null, tab);
        }

        public static PlacedTabPlacement addAfter(class_2960 afterItem, class_2960 tab) {
            return new PlacedTabPlacement(1, afterItem, tab);
        }

        public static PlacedTabPlacement addBefore(class_2960 beforeItem, class_2960 tab) {
            return new PlacedTabPlacement(2, beforeItem, tab);
        }

        public void addToTab(CreativeModeTabRegistry.ItemGroupEntries entries, class_1792 item) {
            if (this.type == 0) {
                entries.add(new class_1935[]{item});
            } else if (this.type == 1) {
                class_1792 addAfter = (class_1792)class_7923.field_41178.method_10223(this.referencedItem);
                if (addAfter == class_1802.field_8162) {
                    AddonPackLog.warning("Tried to add '" + String.valueOf(class_7923.field_41178.method_10221((Object)item)) + "' after unknown item '" + String.valueOf(this.referencedItem) + "' in creative mode tab", new Object[0]);
                    entries.add(new class_1935[]{item});
                } else {
                    entries.addAfter((class_1935)addAfter, new class_1935[]{item});
                }
            } else if (this.type == 2) {
                class_1792 addBefore = (class_1792)class_7923.field_41178.method_10223(this.referencedItem);
                if (addBefore == class_1802.field_8162) {
                    AddonPackLog.warning("Tried to add '" + String.valueOf(class_7923.field_41178.method_10221((Object)item)) + "' before unknown item '" + String.valueOf(this.referencedItem) + "' in creative mode tab", new Object[0]);
                    entries.add(new class_1935[]{item});
                } else {
                    entries.addBefore((class_1935)addBefore, new class_1935[]{item});
                }
            }
        }

        public static PlacedTabPlacement fromJson(JsonElement jsonElement) {
            if (jsonElement.isJsonPrimitive()) {
                return PlacedTabPlacement.add(GsonUtil.convertToResourceLocation(jsonElement, "creative_mode_tab"));
            }
            JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"creative_mode_tab");
            if (class_3518.method_15294((JsonObject)json, (String)"after")) {
                return PlacedTabPlacement.addAfter(GsonUtil.convertToResourceLocation(json.get("after"), "creative_mode_tab.after"), GsonUtil.getAsResourceLocation(json, "tab"));
            }
            if (class_3518.method_15294((JsonObject)json, (String)"before")) {
                return PlacedTabPlacement.addBefore(GsonUtil.convertToResourceLocation(json.get("before"), "creative_mode_tab.after"), GsonUtil.getAsResourceLocation(json, "tab"));
            }
            return PlacedTabPlacement.add(GsonUtil.getAsResourceLocation(json, "tab"));
        }

        public JsonElement toJson() {
            if (this.type == 0) {
                return new JsonPrimitive(this.tab.toString());
            }
            JsonObject json = new JsonObject();
            json.addProperty(this.type == 1 ? "after" : "before", this.referencedItem.toString());
            json.addProperty("tab", this.tab.toString());
            return json;
        }
    }

    public static interface ItemTypeSerializer
    extends IDocumentedConfigurable {
        public IAddonItem parse(JsonObject var1, class_1792.class_1793 var2);
    }
}

