/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3489;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6862;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.item.SimpleToolTier;

public class ToolTierParser
extends class_4309 {
    private static final Map<class_2960, class_1832> TIERS = new HashMap<class_2960, class_1832>();

    public ToolTierParser() {
        super(AddonParser.GSON, "tool_tiers");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        ToolTierParser.registerToolTier(new class_2960("wood"), (class_1832)class_1834.field_8922);
        ToolTierParser.registerToolTier(new class_2960("stone"), (class_1832)class_1834.field_8927);
        ToolTierParser.registerToolTier(new class_2960("iron"), (class_1832)class_1834.field_8923);
        ToolTierParser.registerToolTier(new class_2960("gold"), (class_1832)class_1834.field_8929);
        ToolTierParser.registerToolTier(new class_2960("diamond"), (class_1832)class_1834.field_8930);
        ToolTierParser.registerToolTier(new class_2960("netherite"), (class_1832)class_1834.field_22033);
        AtomicInteger i = new AtomicInteger();
        object.forEach((id, jsonElement) -> {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"$");
                SimpleToolTier toolTier = ToolTierParser.parse(id, json);
                ToolTierParser.registerToolTier(id, (class_1832)toolTier);
                i.getAndIncrement();
            }
            catch (Exception e) {
                class_128 crashReport = class_128.method_560((Throwable)e, (String)("Error while parsing addonpack tool tier  '" + String.valueOf(id) + "'"));
                class_129 reportCategory = crashReport.method_556("Addon Tool Tier", 1);
                reportCategory.method_578("Resource name", id);
                throw new class_148(crashReport);
            }
        });
        AddonPackLog.info("Registered " + i.get() + " addonpack tool tiers", new Object[0]);
    }

    public static void registerToolTier(class_2960 id, class_1832 tier) {
        TIERS.put(id, tier);
    }

    public static class_1832 getToolTier(class_2960 id) {
        return TIERS.get(id);
    }

    public static Set<class_2960> getIds() {
        return TIERS.keySet();
    }

    public static SimpleToolTier parse(class_2960 id, JsonObject json) {
        return new SimpleToolTier(GsonUtil.getAsIntMin(json, "level", 0), GsonUtil.getAsIntMin(json, "uses", 1), GsonUtil.getAsFloatMin(json, "speed", 0.0f), GsonUtil.getAsFloatMin(json, "attack_damage_bonus", 0.0f), GsonUtil.getAsIntMin(json, "enchantment_value", 0), () -> json.has("repair_ingredient") ? class_1856.method_52177((JsonElement)json.get("repair_ingredient")) : class_1856.field_9017);
    }

    public static HTMLBuilder documentationBuilder() {
        JsonDocumentationBuilder builder = new JsonDocumentationBuilder().setDescription("Each tool type goes into a seperate file into the 'addon/[namespace]/tool_tiers' folder, which can then be used for custom tools (swords, pickaxes, etc.).");
        builder.addProperty("level", Integer.class).description("Determines the mining level and what blocks can be harvested. For reference: iron has 2, diamond has 3. So obsidian can only be mined with tools with the level 3 or above, thats why you need a diamond pickaxe for it").required().exampleJson((JsonElement)new JsonPrimitive((Number)2));
        builder.addProperty("uses", Integer.class).description("Determines the durability for tool. For reference: iron has 250, diamond has 1561").required().exampleJson((JsonElement)new JsonPrimitive((Number)420));
        builder.addProperty("speed", Float.class).description("Determines the mining speed. For reference: iron has 6.0, diamond has 8.0").required().exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(6.9f)));
        builder.addProperty("attack_damage_bonus", Float.class).description("Determines the additional attack damage. For reference: iron has 2.0, diamond has 3.0").required().exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(2.5f)));
        builder.addProperty("enchantment_value", Integer.class).description("Determines the enchantibility of the item. For reference: iron has 9, diamond 10, gold 25.").required().exampleJson((JsonElement)new JsonPrimitive((Number)12));
        builder.addProperty("repair_ingredient", class_1856.class).description("Ingredient definition for repairing the item in an anvil. Can be defined like in recipes.").fallback(class_1856.field_9017, "empty ingredient").exampleJson(class_1856.method_8106((class_6862)class_3489.field_36269).method_8089());
        return new HTMLBuilder(new class_2960("palladium", "tool_tiers"), "Tool Tiers").add(HTMLBuilder.heading("Tool Tiers")).addDocumentation(builder);
    }
}

