/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5601;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.client.dynamictexture.DefaultDynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public abstract class DynamicModelLayerLocation {
    public abstract class_5601 getModelLayer(DataContext var1);

    public static DynamicModelLayerLocation fromJson(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return new Static(GsonUtil.convertToModelLayerLocation(jsonElement, "$"));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            if (class_3518.method_15294((JsonObject)json, (String)"variables")) {
                Dynamic location = new Dynamic(class_3518.method_15265((JsonObject)json, (String)"base"));
                JsonObject variables = class_3518.method_15296((JsonObject)json, (String)"variables");
                for (Map.Entry entry : variables.entrySet()) {
                    JsonObject variableJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                    class_2960 variableId = GsonUtil.getAsResourceLocation(variableJson, "type");
                    ITextureVariableSerializer serializer = DynamicTextureManager.getTextureVariableSerializer(variableId);
                    if (serializer != null) {
                        ITextureVariable variable = serializer.parse(variableJson);
                        location.addVariable((String)entry.getKey(), variable);
                        continue;
                    }
                    AddonPackLog.error("Unknown texture variable '" + String.valueOf(variableId) + "'", new Object[0]);
                }
                return location;
            }
            return new Static(GsonUtil.getAsModelLayerLocation(json, "base"));
        }
        throw new JsonSyntaxException("Model layer must be a string or an object");
    }

    public static class Static
    extends DynamicModelLayerLocation {
        private final class_5601 modelLayer;

        public Static(class_5601 modelLayer) {
            this.modelLayer = modelLayer;
        }

        @Override
        public class_5601 getModelLayer(DataContext context) {
            return this.modelLayer;
        }
    }

    public static class Dynamic
    extends DynamicModelLayerLocation {
        private final String base;
        private final Map<String, ITextureVariable> textureVariableMap = Maps.newHashMap();

        public Dynamic(String base) {
            this.base = base;
        }

        public Dynamic addVariable(String name, ITextureVariable variable) {
            this.textureVariableMap.put(name, variable);
            return this;
        }

        @Override
        public class_5601 getModelLayer(DataContext context) {
            String model = DefaultDynamicTexture.replaceVariables(this.base, context, this.textureVariableMap);
            String[] s = model.split("#", 2);
            if (s.length == 1) {
                return new class_5601(new class_2960(s[0]), "main");
            }
            return new class_5601(new class_2960(s[0]), s[1]);
        }
    }
}

