/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.threetag.palladium.client.dynamictexture.DynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.Nullable;

public class TextureReference {
    private final boolean dynamic;
    private final class_2960 path;

    private TextureReference(boolean dynamic, class_2960 path) {
        this.dynamic = dynamic;
        this.path = path;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_2960 getTexture(DataContext context) {
        if (this.dynamic) {
            DynamicTexture dyn = DynamicTextureManager.INSTANCE.get(this.path);
            return dyn != null ? dyn.getTexture(context) : null;
        }
        return this.path;
    }

    public static TextureReference normal(class_2960 path) {
        return new TextureReference(false, path);
    }

    public static TextureReference dynamic(class_2960 path) {
        return new TextureReference(true, path);
    }

    public static TextureReference parse(String path) {
        if (path.startsWith("#")) {
            return TextureReference.dynamic(new class_2960(path.substring(1)));
        }
        return TextureReference.normal(new class_2960(path));
    }

    public void toBuffer(class_2540 buf) {
        buf.writeBoolean(this.dynamic);
        buf.method_10812(this.path);
    }

    public static TextureReference fromBuffer(class_2540 buf) {
        return new TextureReference(buf.readBoolean(), buf.method_10810());
    }

    public String toString() {
        return (this.dynamic ? "#" : "") + this.path.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextureReference that = (TextureReference)o;
        return this.dynamic == that.dynamic && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.dynamic, this.path);
    }
}

