/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.transformer;

import java.awt.Color;
import java.io.IOException;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_3300;
import net.minecraft.class_5253;
import net.threetag.palladium.client.dynamictexture.transformer.ITextureTransformer;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.Nullable;

public record ColorTextureTransformer(DynamicColor rawColor, boolean ignoreBlank, DynamicColor filter) implements ITextureTransformer
{
    @Override
    public class_1011 transform(DataContext context, class_1011 texture, class_3300 manager, Function<String, String> stringConverter) throws IOException {
        Color color = this.rawColor.getColor(context, stringConverter);
        Color filter = this.filter != null ? this.filter.getColor(context, stringConverter) : null;
        for (int y = 0; y < texture.method_4323(); ++y) {
            for (int x = 0; x < texture.method_4307(); ++x) {
                this.blendPixel(texture, x, y, color, filter);
            }
        }
        return texture;
    }

    public void blendPixel(class_1011 texture, int x, int y, Color color, @Nullable Color filter) {
        if (texture.method_4318() != class_1011.class_1012.field_4997) {
            throw new UnsupportedOperationException("Can only call blendPixel with RGBA format");
        }
        int i = texture.method_4315(x, y);
        if (class_5253.class_8045.method_48342((int)i) == 0 && this.ignoreBlank) {
            return;
        }
        int origR = class_5253.class_8045.method_48345((int)i);
        int origG = class_5253.class_8045.method_48346((int)i);
        int origB = class_5253.class_8045.method_48347((int)i);
        if (filter != null && !ColorTextureTransformer.colorMatches(origR, origG, origB, filter)) {
            return;
        }
        float f = (float)color.getAlpha() / 255.0f;
        float g = (float)color.getBlue() / 255.0f;
        float h = (float)color.getGreen() / 255.0f;
        float j = (float)color.getRed() / 255.0f;
        float l = (float)origB / 255.0f;
        float m = (float)origG / 255.0f;
        float n = (float)origR / 255.0f;
        float p = 1.0f - f;
        float r = g * f + l * p;
        float s = h * f + m * p;
        float t = j * f + n * p;
        if (r > 1.0f) {
            r = 1.0f;
        }
        if (s > 1.0f) {
            s = 1.0f;
        }
        if (t > 1.0f) {
            t = 1.0f;
        }
        int v = (int)(r * 255.0f);
        int w = (int)(s * 255.0f);
        int z = (int)(t * 255.0f);
        texture.method_4305(x, y, class_5253.class_8045.method_48344((int)class_5253.class_8045.method_48342((int)i), (int)v, (int)w, (int)z));
    }

    private static boolean colorMatches(int red, int green, int blue, Color color) {
        return color.getRed() == red && color.getGreen() == green && color.getBlue() == blue;
    }
}

