/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractFloatTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.client.model.animation.FlightAnimation;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.util.Easing;
import net.threetag.palladium.util.context.DataContext;

public class CapeTextureVariable
extends AbstractFloatTextureVariable {
    public final boolean bobbing;

    public CapeTextureVariable(boolean bobbing, List<Pair<AbstractFloatTextureVariable.Operation, JsonPrimitive>> operations) {
        super(operations);
        this.bobbing = bobbing;
    }

    @Override
    public float getNumber(DataContext context) {
        class_1657 player = context.getPlayer();
        if (player != null) {
            double d0 = class_3532.method_16436((double)1.0, (double)player.field_7524, (double)player.field_7500) - class_3532.method_16436((double)1.0, (double)player.field_6014, (double)player.method_23317());
            double d1 = class_3532.method_16436((double)1.0, (double)player.field_7502, (double)player.field_7521) - class_3532.method_16436((double)1.0, (double)player.field_6036, (double)player.method_23318());
            double d2 = class_3532.method_16436((double)1.0, (double)player.field_7522, (double)player.field_7499) - class_3532.method_16436((double)1.0, (double)player.field_5969, (double)player.method_23321());
            float f = player.field_6220 + (player.field_6283 - player.field_6220);
            double d3 = class_3532.method_15374((float)(f * ((float)Math.PI / 180)));
            double d4 = -class_3532.method_15362((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = class_3532.method_15363((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            if ((f2 = class_3532.method_15363((float)f2, (float)0.0f, (float)150.0f)) < 0.0f) {
                f2 = 0.0f;
            }
            if (this.bobbing) {
                float f4 = class_3532.method_16439((float)1.0f, (float)player.field_7505, (float)player.field_7483);
                f1 += class_3532.method_15374((float)(class_3532.method_16439((float)1.0f, (float)player.field_6039, (float)player.field_5973) * 6.0f)) * 32.0f * f4;
            }
            float rotation = 6.0f + f2 / 2.0f + f1;
            float val = class_3532.method_15363((float)(rotation + 10.0f), (float)0.0f, (float)90.0f);
            if (player instanceof PalladiumPlayerExtension) {
                class_241 vec2;
                class_241 vec1;
                double tilt;
                PalladiumPlayerExtension extension = (PalladiumPlayerExtension)player;
                FlightHandler flight = extension.palladium$getFlightHandler();
                float hoveringAnimation = flight.getHoveringAnimation(1.0f) - flight.getLevitationAnimation(1.0f);
                if (hoveringAnimation > 0.0f) {
                    val += (20.0f - val) * hoveringAnimation;
                }
                float prevFlightAnimation = flight.getFlightAnimation(0.0f);
                float flightAnimation = flight.getFlightAnimation(1.0f);
                if (flightAnimation <= 1.0f) {
                    return val;
                }
                flightAnimation = (flightAnimation - 1.0f) / 2.0f;
                prevFlightAnimation = (prevFlightAnimation - 1.0f) / 2.0f;
                float dest = 10.0f;
                if (prevFlightAnimation > flightAnimation) {
                    dest = (1.0f - class_3532.method_15363((float)(flightAnimation * 4.0f - 3.0f), (float)0.0f, (float)1.0f)) * 70.0f;
                    flightAnimation = class_3532.method_15363((float)(flightAnimation * 3.0f), (float)0.0f, (float)1.0f);
                }
                if ((tilt = class_3532.method_15350((double)FlightAnimation.angleBetweenVector(vec1 = FlightAnimation.to2D(flight.getFlightVector(1.0f)), vec2 = FlightAnimation.to2D(flight.getLookAngle(1.0f))), (double)-0.5, (double)0.5) * 90.0 * (double)flight.getHorizontalSpeed(1.0f)) != 0.0) {
                    dest = class_3532.method_15379((float)((float)tilt));
                }
                val += (dest - val) * Easing.INOUTCIRC.apply(flightAnimation);
            }
            return val;
        }
        return 0.0f;
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new CapeTextureVariable(class_3518.method_15258((JsonObject)json, (String)"bobbing", (boolean)true), AbstractFloatTextureVariable.parseOperations(json));
        }

        @Override
        public String getDocumentationDescription() {
            return "Returns the tilt of the player's cape.";
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Cape");
            builder.addProperty("bobbing", Boolean.class).description("Determines of bobbing should be taken into account when doing the calculation").fallback(true).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            AbstractFloatTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("cape");
        }
    }
}

