/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1800;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5272;
import net.minecraft.class_638;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractFloatTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.AbstractIntegerTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public class ItemModelPropertyVariable
extends AbstractFloatTextureVariable {
    private final class_2960 modelProperty;
    private final float fallback;

    public ItemModelPropertyVariable(class_2960 modelProperty, float fallback, List<Pair<AbstractFloatTextureVariable.Operation, JsonPrimitive>> operations) {
        super(operations);
        this.modelProperty = modelProperty;
        this.fallback = fallback;
    }

    @Override
    public float getNumber(DataContext context) {
        class_1799 item = context.getItem();
        if (!item.method_7960()) {
            class_1800 itemProperty = class_5272.method_27878((class_1792)item.method_7909(), (class_2960)this.modelProperty);
            if (itemProperty == null) {
                return this.fallback;
            }
            return itemProperty.call(item, (class_638)context.getLevel(), context.getLivingEntity(), 0);
        }
        return this.fallback;
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new ItemModelPropertyVariable(GsonUtil.getAsResourceLocation(json, "model_property"), class_3518.method_15277((JsonObject)json, (String)"fallback", (float)0.0f), AbstractFloatTextureVariable.parseOperations(json));
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Item Model Property");
            builder.addProperty("model_property", class_2960.class).description("ID of the item model property to get.").required().exampleJson((JsonElement)new JsonPrimitive("minecraft:damage"));
            builder.addProperty("fallback", Float.class).description("If the item model property is not found on the item, this value will be used instead.").fallback(Float.valueOf(0.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(0.0f)));
            AbstractIntegerTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public String getDocumentationDescription() {
            return "When used in an item-context, this returns the value of the specified item model property, such as \"custom_model_data\" or \"damage\".";
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("item_model_property");
        }
    }
}

