/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.energybeam;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_742;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.energybeam.EnergyBeamRenderer;
import net.threetag.palladium.client.renderer.LaserRenderer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.PerspectiveValue;
import net.threetag.palladium.util.SizeUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;
import org.joml.Vector2f;

public class LightningBeamRenderer
extends EnergyBeamRenderer {
    private final LaserRenderer laserRenderer;
    private final int segments;
    private final int frequency;
    private final float spread;
    private final PerspectiveValue<Boolean> visibility;

    public LightningBeamRenderer(LaserRenderer laserRenderer, int segments, int frequency, float spread, PerspectiveValue<Boolean> visibility) {
        this.laserRenderer = laserRenderer;
        this.segments = segments;
        this.frequency = frequency;
        this.spread = spread;
        this.visibility = visibility;
    }

    @Override
    public void render(class_742 player, class_243 origin, class_243 target, float lengthMultiplier, class_4587 poseStack, class_4597 bufferSource, int packedLightIn, boolean isFirstPerson, float partialTick) {
        if (this.visibility.getForPlayer((class_1657)player).booleanValue()) {
            Vector2f size = this.laserRenderer.getSize();
            float widthScale = SizeUtil.getInstance().getModelWidthScale((class_1297)player, partialTick);
            float heightScale = SizeUtil.getInstance().getModelHeightScale((class_1297)player, partialTick);
            this.laserRenderer.size(size.mul(widthScale, heightScale, new Vector2f()));
            class_243 segmentPartVec = target.method_1020(origin).method_1021((double)(1.0f / (float)this.segments));
            class_5819 randomStart = class_5819.method_43049((long)(player.method_5628() + player.field_6012 / this.frequency));
            class_243 startVec = origin;
            for (int i = 0; i < this.segments; ++i) {
                float currentProgress;
                float startProgress = 1.0f / (float)this.segments * (float)i;
                float endProgress = 1.0f / (float)this.segments * (float)(i + 1);
                float f = lengthMultiplier <= startProgress ? 0.0f : (currentProgress = lengthMultiplier >= endProgress ? 1.0f : (lengthMultiplier - startProgress) / (endProgress - startProgress));
                if (!(currentProgress > 0.0f)) continue;
                class_243 end = i == this.segments - 1 ? target : origin.method_1019(segmentPartVec.method_1021((double)(i + 1))).method_1019(LightningBeamRenderer.randomizeVector(randomStart, this.spread));
                class_243 offset = startVec.method_1020(origin);
                poseStack.method_22903();
                poseStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
                this.laserRenderer.length((float)startVec.method_1022(end) * currentProgress).faceAndRender(DataContext.forEntity((class_1297)player), poseStack, bufferSource, startVec, end, player.field_6012, partialTick);
                poseStack.method_22909();
                startVec = end;
            }
            this.laserRenderer.size(size);
        }
    }

    private static class_243 randomizeVector(class_5819 random, float spread) {
        return new class_243((double)((random.method_43057() - 0.5f) * 2.0f * spread), (double)((random.method_43057() - 0.5f) * 2.0f * spread), (double)((random.method_43057() - 0.5f) * 2.0f * spread));
    }

    public static class Serializer
    extends EnergyBeamRenderer.Serializer {
        public static final class_2960 ID = Palladium.id("lightning");

        @Override
        public EnergyBeamRenderer fromJson(JsonObject json) {
            return new LightningBeamRenderer(LaserRenderer.fromJson(json, 1), GsonUtil.getAsIntMin(json, "segments", 1, 5), GsonUtil.getAsIntMin(json, "frequency", 1, 2), GsonUtil.getAsFloatMin(json, "spread", 0.0f, 5.0f) / 16.0f, PerspectiveValue.getFromJson(json, "visibility", JsonElement::getAsBoolean, true));
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Lightning");
            builder.addProperty("segments", Integer.class).description("Determines how many split segments the lightning will have").fallback(5).exampleJson((JsonElement)new JsonPrimitive((Number)5));
            builder.addProperty("frequency", Integer.class).description("Determines how many ticks it takes for the beam to change its offset position").fallback(2).exampleJson((JsonElement)new JsonPrimitive((Number)2));
            builder.addProperty("spread", Float.class).description("Determines how far each offset segment-corner spreads from the center").fallback(Float.valueOf(5.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)5));
            LaserRenderer.generateDocumentation(builder, 1, false);
            JsonObject exampleJson = new JsonObject();
            exampleJson.addProperty("first_person", Boolean.valueOf(true));
            exampleJson.addProperty("third_person", Boolean.valueOf(true));
            builder.addProperty("visibility", Boolean.class).description("Determines if its visible.").fallback(true).exampleJson((JsonElement)exampleJson);
        }

        @Override
        public class_2960 getId() {
            return ID;
        }
    }
}

