/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.util.BedrockModelUtil;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.NotNull;

public class ModelLayerManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ModelLayerManager() {
        super(GSON, "palladium/model_layers");
    }

    protected void apply(Map<class_2960, JsonElement> object, @NotNull class_3300 resourceManager, @NotNull class_3695 profiler) {
        HashMap jsonRoots = new HashMap();
        class_5599 entityModels = class_310.method_1551().method_31974();
        Map codeRoots = entityModels.field_27542;
        HashMap roots = new HashMap(codeRoots);
        object.forEach((id, jsonElement) -> {
            class_5601 layerLocation = ModelLayerManager.mapPathToModelLayerLoc(id);
            try {
                class_5607 layerDefinition = ModelLayerManager.parseLayerDefinition(jsonElement.getAsJsonObject(), layerLocation != null ? layerLocation.toString() : id.toString());
                if (layerLocation != null) {
                    jsonRoots.put(layerLocation, layerDefinition);
                }
                jsonRoots.put(new class_5601(id, "main"), layerDefinition);
            }
            catch (Exception e) {
                AddonPackLog.error("Error parsing entity model json " + String.valueOf(id), e);
            }
        });
        roots.putAll(jsonRoots);
        entityModels.field_27542 = ImmutableMap.copyOf(roots);
        ModelLayerManager.dumpLayers();
    }

    public static class_5607 parseLayerDefinition(JsonObject json, String id) {
        if (class_3518.method_15294((JsonObject)json, (String)"minecraft:geometry")) {
            return BedrockModelUtil.parseAsLayerDefinition(json);
        }
        AddonPackLog.warning("Model layer '" + id + "' still uses Palladium Entity Format! Please switch to Bedrock Entity Format.", new Object[0]);
        class_5609 meshDefinition = new class_5609();
        class_5610 root = meshDefinition.method_32111();
        JsonObject parts = class_3518.method_15296((JsonObject)json, (String)"mesh");
        for (Map.Entry entry : parts.entrySet()) {
            String key = (String)entry.getKey();
            JsonObject part = ((JsonElement)entry.getValue()).getAsJsonObject();
            ModelLayerManager.parseCubeListBuilder(key, root, part);
        }
        return class_5607.method_32110((class_5609)meshDefinition, (int)class_3518.method_15260((JsonObject)json, (String)"texture_width"), (int)class_3518.method_15260((JsonObject)json, (String)"texture_height"));
    }

    public static void parseCubeListBuilder(String name, class_5610 parent, JsonObject json) {
        JsonArray cubes = class_3518.method_15261((JsonObject)json, (String)"cubes");
        class_5606 builder = class_5606.method_32108();
        for (JsonElement j : cubes) {
            JsonObject cubeJson = j.getAsJsonObject();
            float[] origin = GsonUtil.getFloatArray(cubeJson, 3, "origin");
            float[] dimensions = GsonUtil.getFloatArray(cubeJson, 3, "dimensions");
            int[] textureOffset = GsonUtil.getIntArray(cubeJson, 2, "texture_offset", 0, 0);
            float[] textureScale = GsonUtil.getFloatArray(cubeJson, 2, "texture_scale", 1.0f, 1.0f);
            float[] deformation = GsonUtil.getFloatArray(cubeJson, 3, "deformation", 0.0f, 0.0f, 0.0f);
            builder.method_32106(class_3518.method_15258((JsonObject)cubeJson, (String)"mirror", (boolean)false));
            builder.method_32101(textureOffset[0], textureOffset[1]);
            builder.method_32099(origin[0], origin[1], origin[2], dimensions[0], dimensions[1], dimensions[2], new class_5605(deformation[0], deformation[1], deformation[2]), textureScale[0], textureScale[1]);
        }
        class_5603 partPose = class_5603.field_27701;
        if (class_3518.method_15294((JsonObject)json, (String)"part_pose")) {
            JsonObject partPoseJson = class_3518.method_15296((JsonObject)json, (String)"part_pose");
            float[] offset = GsonUtil.getFloatArray(partPoseJson, 3, "offset", 0.0f, 0.0f, 0.0f);
            float[] rotation1 = GsonUtil.getFloatArray(partPoseJson, 3, "rotation", 0.0f, 0.0f, 0.0f);
            double[] rotation = new double[3];
            for (int i = 0; i < 3; ++i) {
                rotation[i] = Math.toRadians(rotation1[i]);
            }
            partPose = class_5603.method_32091((float)offset[0], (float)offset[1], (float)offset[2], (float)((float)rotation[0]), (float)((float)rotation[1]), (float)((float)rotation[2]));
        }
        class_5610 partDefinition = parent.method_32117(name, builder, partPose);
        if (class_3518.method_15294((JsonObject)json, (String)"children")) {
            JsonObject children = class_3518.method_15296((JsonObject)json, (String)"children");
            for (Map.Entry entry : children.entrySet()) {
                String key = (String)entry.getKey();
                JsonObject part = ((JsonElement)entry.getValue()).getAsJsonObject();
                ModelLayerManager.parseCubeListBuilder(key, partDefinition, part);
            }
        }
    }

    private static class_5601 mapPathToModelLayerLoc(class_2960 path) {
        int idx = path.method_12832().indexOf(47);
        if (idx == -1) {
            return null;
        }
        return new class_5601(new class_2960(path.method_12836(), path.method_12832().substring(idx + 1)), path.method_12832().substring(0, idx));
    }

    public static void dumpLayers() {
        File oldPlayerFile = new File(HTMLBuilder.SUBFOLDER, "palladium/models/minecraft/main/player.json");
        File oldFile = new File(HTMLBuilder.SUBFOLDER, "palladium/models/");
        File folder = new File(HTMLBuilder.SUBFOLDER, "palladium/vanilla_models/");
        if (oldPlayerFile.exists()) {
            ModelLayerManager.deleteDirectory(oldFile);
            System.out.println("HALLO DELETE");
        }
        class_310.method_1551().method_31974().field_27542.forEach((modelLayerLocation, layerDefinition) -> {
            if (!modelLayerLocation.method_35744().equalsIgnoreCase("main") || !modelLayerLocation.method_35743().method_12836().equalsIgnoreCase("minecraft")) {
                return;
            }
            File outputFile = new File(folder, modelLayerLocation.method_35743().method_12832() + ".json");
            try {
                JsonObject json = BedrockModelUtil.toJsonModel(layerDefinition, modelLayerLocation.toString());
                if (!outputFile.exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                Files.writeString(outputFile.toPath(), (CharSequence)GSON.toJson((JsonElement)json), new OpenOption[0]);
            }
            catch (IOException e) {
                Palladium.LOGGER.error("Error while dumping model {}", (Object)outputFile, (Object)e);
            }
        });
    }

    private static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                ModelLayerManager.deleteDirectory(file);
            }
        }
        directoryToBeDeleted.delete();
    }
}

