/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model.animation;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import net.minecraft.class_572;
import net.minecraft.class_742;
import net.threetag.palladium.client.model.animation.PalladiumAnimation;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.util.Easing;

@Environment(value=EnvType.CLIENT)
public class HoveringAnimation
extends PalladiumAnimation {
    public HoveringAnimation(int priority) {
        super(priority);
    }

    @Override
    public void animate(PalladiumAnimation.Builder builder, class_742 player, class_572<?> model, PalladiumAnimation.FirstPersonContext firstPersonContext, float partialTicks) {
        boolean active;
        boolean bl = active = !firstPersonContext.firstPerson();
        if (active && player instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)player;
            FlightHandler flight = extension.palladium$getFlightHandler();
            float anim = flight.getHoveringAnimation(partialTicks);
            if (anim <= 0.0f) {
                return;
            }
            FlightHandler.FlightAnimationType type = FlightHandler.getAnimationType((class_1309)player);
            if (type == FlightHandler.FlightAnimationType.HEROIC) {
                this.animateHeroic(builder, player, anim, partialTicks);
            } else {
                this.animateNormal(builder, player, anim, partialTicks);
            }
            this.addAttackAnimation(builder, player, model);
        }
    }

    public void animateNormal(PalladiumAnimation.Builder builder, class_742 player, float animationProgress, float partialTicks) {
        float hover = (float)Math.sin(((float)player.field_6012 + partialTicks) / 10.0f);
        builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM).resetXRot().resetYRot().resetZRot().setYRotDegrees(7.5f).setZRotDegrees(7.5f - hover * 2.5f).animate(Easing.OUTCIRC, animationProgress);
        builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM).resetXRot().resetYRot().resetZRot().setYRotDegrees(-7.5f).setZRotDegrees(-7.5f + hover * 2.5f).animate(Easing.OUTCIRC, animationProgress);
        builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_LEG).setXRotDegrees(2.5f - hover * 5.0f).setYRotDegrees(7.5f).setZRotDegrees(2.5f).animate(Easing.OUTCIRC, animationProgress);
        builder.get(PalladiumAnimation.PlayerModelPart.LEFT_LEG).setXRotDegrees(-2.5f + hover * 5.0f).setYRotDegrees(-7.5f).setZRotDegrees(-2.5f).animate(Easing.OUTCIRC, animationProgress);
    }

    public void animateHeroic(PalladiumAnimation.Builder builder, class_742 player, float animationProgress, float partialTicks) {
        float hover = (float)Math.sin(((float)player.field_6012 + partialTicks) / 10.0f);
        builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM).resetXRot().resetYRot().resetZRot().setXRotDegrees(-2.5f).setYRotDegrees(10.0f).setZRotDegrees(7.5f - hover * 2.5f).animate(Easing.OUTCIRC, animationProgress);
        builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM).resetXRot().resetYRot().resetZRot().setXRotDegrees(5.0f).setYRotDegrees(-10.0f).setZRotDegrees(-7.5f + hover * 2.5f).animate(Easing.OUTCIRC, animationProgress);
        builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_LEG).setX(-2.9f).setY(11.0f).setZ(-2.0f).setXRotDegrees(20.0f - hover * 5.0f).setYRotDegrees(15.0f).setZRotDegrees(-5.0f).animate(Easing.OUTCIRC, animationProgress);
        builder.get(PalladiumAnimation.PlayerModelPart.LEFT_LEG).setXRotDegrees(2.5f + hover * 5.0f).setYRotDegrees(0.0f).setZRotDegrees(-2.0f).animate(Easing.OUTCIRC, animationProgress);
    }

    protected void addAttackAnimation(PalladiumAnimation.Builder builder, class_742 player, class_572<?> model) {
        if (!(model.field_3447 <= 0.0f)) {
            class_1306 humanoidArm = this.getAttackArm(player);
            PalladiumAnimation.PartAnimationData modelPart = humanoidArm == class_1306.field_6183 ? builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM) : builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM);
            float bodyYRot = model.field_3391.field_3675;
            builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM).setX(-class_3532.method_15362((float)bodyYRot) * 5.0f).setZ(class_3532.method_15374((float)bodyYRot) * 5.0f).setYRot(bodyYRot);
            builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM).setX(class_3532.method_15362((float)bodyYRot) * 5.0f).setZ(-class_3532.method_15374((float)bodyYRot) * 5.0f).setXRot(bodyYRot).setYRot(bodyYRot);
            float f = 1.0f - model.field_3447;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float g = class_3532.method_15374((float)(f * (float)Math.PI));
            float h = class_3532.method_15374((float)(model.field_3447 * (float)Math.PI)) * -(model.field_3398.field_3654 - 0.7f) * 0.75f;
            modelPart.rotateX(-(g * 1.2f + h)).rotateY(bodyYRot * 2.0f).rotateZ(class_3532.method_15374((float)(model.field_3447 * (float)Math.PI)) * -0.4f);
        }
    }

    private class_1306 getAttackArm(class_742 player) {
        class_1306 humanoidArm = player.method_6068();
        return player.field_6266 == class_1268.field_5808 ? humanoidArm : humanoidArm.method_5928();
    }
}

