/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model.animation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1306;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5603;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.threetag.palladium.util.Easing;

public class PalladiumAnimation {
    private final int priority;

    public PalladiumAnimation(int priority) {
        this.priority = priority;
    }

    public void animate(Builder builder, class_742 player, class_572<?> model, FirstPersonContext firstPersonContext, float partialTicks) {
    }

    public int getPriority() {
        return this.priority;
    }

    public static class PoseStackResult {
        private float x = 0.0f;
        private float y = 0.0f;
        private float z = 0.0f;
        private float x2 = 0.0f;
        private float y2 = 0.0f;
        private float z2 = 0.0f;
        private float xRot = 0.0f;
        private float yRot = 0.0f;
        private float zRot = 0.0f;
        private float xScale = 1.0f;
        private float yScale = 1.0f;
        private float zScale = 1.0f;

        public void apply(class_4587 poseStack) {
            poseStack.method_46416(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
            if (this.zRot != 0.0f) {
                poseStack.method_22907(class_7833.field_40718.rotation(this.zRot));
            }
            if (this.yRot != 0.0f) {
                poseStack.method_22907(class_7833.field_40716.rotation(this.yRot));
            }
            if (this.xRot != 0.0f) {
                poseStack.method_22907(class_7833.field_40714.rotation(this.xRot));
            }
            poseStack.method_46416(this.x2 / 16.0f, this.y2 / 16.0f, this.z2 / 16.0f);
            if (this.xScale != 1.0f || this.yScale != 1.0f || this.zScale != 1.0f) {
                poseStack.method_22905(this.xScale, this.yScale, this.zScale);
            }
        }
    }

    public static class PartOperation {
        private final PartOperationType type;
        private final float value;

        private PartOperation(PartOperationType type, float value) {
            this.type = type;
            this.value = value;
        }

        public void apply(class_630 part, PartOperationTarget target, float multiplier) {
            if (this.type == PartOperationType.SET) {
                float current = target.get(part);
                target.set(part, current + (this.value - current) * multiplier);
            } else if (this.type == PartOperationType.ADD) {
                if (target.scale) {
                    target.set(part, target.get(part) * (1.0f + (this.value - 1.0f) * multiplier));
                } else {
                    target.set(part, target.get(part) + this.value * multiplier);
                }
            } else {
                float current = target.get(part);
                target.set(part, current + (target.get(part.method_41921()) - current) * multiplier);
            }
        }

        public void apply(PoseStackResult result, PartOperationTarget target, float multiplier) {
            if (this.type == PartOperationType.SET) {
                float current = target.get(result);
                target.set(result, current + (this.value - current) * multiplier);
            } else if (this.type == PartOperationType.ADD) {
                if (target.scale) {
                    target.set(result, target.get(result) * (1.0f + (this.value - 1.0f) * multiplier));
                } else {
                    target.set(result, target.get(result) + this.value * multiplier);
                }
            } else {
                float current = target.get(result);
                target.set(result, current + (target.initial - current) * multiplier);
            }
        }
    }

    public static enum PartOperationType {
        ADD,
        ADD_INITIAL,
        SET,
        RESET;

    }

    public static enum PartOperationTarget {
        X_ROT(0.0f, false),
        Y_ROT(0.0f, false),
        Z_ROT(0.0f, false),
        X(0.0f, false),
        Y(0.0f, false),
        Z(0.0f, false),
        X2(0.0f, false),
        Y2(0.0f, false),
        Z2(0.0f, false),
        X_SCALE(1.0f, true),
        Y_SCALE(1.0f, true),
        Z_SCALE(1.0f, true);

        private final float initial;
        private final boolean scale;

        private PartOperationTarget(float initial, boolean scale) {
            this.initial = initial;
            this.scale = scale;
        }

        public float get(class_630 part) {
            return switch (this) {
                case X_ROT -> part.field_3654;
                case Y_ROT -> part.field_3675;
                case Z_ROT -> part.field_3674;
                case X -> part.field_3657;
                case Y -> part.field_3656;
                case Z -> part.field_3655;
                case X_SCALE -> part.field_37938;
                case Y_SCALE -> part.field_37939;
                case Z_SCALE -> part.field_37940;
                default -> 0.0f;
            };
        }

        public float get(PoseStackResult result) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case X_ROT -> result.xRot;
                case Y_ROT -> result.yRot;
                case Z_ROT -> result.zRot;
                case X -> result.x;
                case Y -> result.y;
                case Z -> result.z;
                case X2 -> result.x2;
                case Y2 -> result.y2;
                case Z2 -> result.z2;
                case X_SCALE -> result.xScale;
                case Y_SCALE -> result.yScale;
                case Z_SCALE -> result.zScale;
            };
        }

        public float get(class_5603 pose) {
            return switch (this) {
                case X_ROT -> pose.field_27705;
                case Y_ROT -> pose.field_27706;
                case Z_ROT -> pose.field_27707;
                case X -> pose.field_27702;
                case Y -> pose.field_27703;
                case Z -> pose.field_27704;
                case X2, Y2, Z2 -> 0.0f;
                default -> 1.0f;
            };
        }

        public void set(class_630 part, float value) {
            switch (this) {
                case X_ROT: {
                    part.field_3654 = value;
                    break;
                }
                case Y_ROT: {
                    part.field_3675 = value;
                    break;
                }
                case Z_ROT: {
                    part.field_3674 = value;
                    break;
                }
                case X: {
                    part.field_3657 = value;
                    break;
                }
                case Y: {
                    part.field_3656 = value;
                    break;
                }
                case Z: {
                    part.field_3655 = value;
                    break;
                }
                case X_SCALE: {
                    part.field_37938 = value;
                    break;
                }
                case Y_SCALE: {
                    part.field_37939 = value;
                    break;
                }
                case Z_SCALE: {
                    part.field_37940 = value;
                }
            }
        }

        public void set(PoseStackResult result, float value) {
            switch (this) {
                case X_ROT: {
                    result.xRot = value;
                    break;
                }
                case Y_ROT: {
                    result.yRot = value;
                    break;
                }
                case Z_ROT: {
                    result.zRot = value;
                    break;
                }
                case X: {
                    result.x = value;
                    break;
                }
                case Y: {
                    result.y = value;
                    break;
                }
                case Z: {
                    result.z = value;
                    break;
                }
                case X2: {
                    result.x2 = value;
                    break;
                }
                case Y2: {
                    result.y2 = value;
                    break;
                }
                case Z2: {
                    result.z2 = value;
                    break;
                }
                case X_SCALE: {
                    result.xScale = value;
                    break;
                }
                case Y_SCALE: {
                    result.yScale = value;
                    break;
                }
                case Z_SCALE: {
                    result.zScale = value;
                }
            }
        }
    }

    public static class PartAnimationData {
        private final Map<PartOperationTarget, List<PartOperation>> operations = new LinkedHashMap<PartOperationTarget, List<PartOperation>>();
        private float multiplier = 1.0f;

        public PartAnimationData setXRot(float rot) {
            this.operations.computeIfAbsent(PartOperationTarget.X_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, rot));
            return this;
        }

        public PartAnimationData setXRotDegrees(float degrees) {
            return this.setXRot((float)Math.toRadians(degrees));
        }

        public PartAnimationData setYRot(float rot) {
            this.operations.computeIfAbsent(PartOperationTarget.Y_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, rot));
            return this;
        }

        public PartAnimationData setYRotDegrees(float degrees) {
            return this.setYRot((float)Math.toRadians(degrees));
        }

        public PartAnimationData setZRot(float rot) {
            this.operations.computeIfAbsent(PartOperationTarget.Z_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, rot));
            return this;
        }

        public PartAnimationData setZRotDegrees(float degrees) {
            return this.setZRot((float)Math.toRadians(degrees));
        }

        public PartAnimationData rotateX(float rot) {
            this.operations.computeIfAbsent(PartOperationTarget.X_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, rot));
            return this;
        }

        public PartAnimationData rotateXDegrees(float degrees) {
            return this.rotateX((float)Math.toRadians(degrees));
        }

        public PartAnimationData rotateY(float rot) {
            this.operations.computeIfAbsent(PartOperationTarget.Y_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, rot));
            return this;
        }

        public PartAnimationData rotateYDegrees(float degrees) {
            return this.rotateY((float)Math.toRadians(degrees));
        }

        public PartAnimationData rotateZ(float rot) {
            this.operations.computeIfAbsent(PartOperationTarget.Z_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, rot));
            return this;
        }

        public PartAnimationData rotateZDegrees(float degrees) {
            return this.rotateZ((float)Math.toRadians(degrees));
        }

        public PartAnimationData resetXRot() {
            this.operations.computeIfAbsent(PartOperationTarget.X_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.RESET, 0.0f));
            return this;
        }

        public PartAnimationData resetYRot() {
            this.operations.computeIfAbsent(PartOperationTarget.Y_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.RESET, 0.0f));
            return this;
        }

        public PartAnimationData resetZRot() {
            this.operations.computeIfAbsent(PartOperationTarget.Z_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.RESET, 0.0f));
            return this;
        }

        public PartAnimationData moveX(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.X, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, amount));
            return this;
        }

        @Deprecated
        public PartAnimationData translateX(float amount) {
            return this.setX(amount);
        }

        public PartAnimationData setX(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.X, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, amount));
            return this;
        }

        public PartAnimationData resetX() {
            this.operations.computeIfAbsent(PartOperationTarget.X, t -> new LinkedList()).add(new PartOperation(PartOperationType.RESET, 0.0f));
            return this;
        }

        public PartAnimationData moveY(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Y, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, amount));
            return this;
        }

        @Deprecated
        public PartAnimationData translateY(float amount) {
            return this.setY(amount);
        }

        public PartAnimationData setY(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Y, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, amount));
            return this;
        }

        public PartAnimationData setY2(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Y2, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, amount));
            return this;
        }

        public PartAnimationData resetY() {
            this.operations.computeIfAbsent(PartOperationTarget.Y, t -> new LinkedList()).add(new PartOperation(PartOperationType.RESET, 0.0f));
            return this;
        }

        public PartAnimationData moveZ(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Z, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, amount));
            return this;
        }

        @Deprecated
        public PartAnimationData translateZ(float amount) {
            return this.setZ(amount);
        }

        public PartAnimationData setZ(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Z, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, amount));
            return this;
        }

        public PartAnimationData resetZ() {
            this.operations.computeIfAbsent(PartOperationTarget.Z, t -> new LinkedList()).add(new PartOperation(PartOperationType.RESET, 0.0f));
            return this;
        }

        public PartAnimationData scaleX(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.X_SCALE, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, amount));
            return this;
        }

        public PartAnimationData scaleY(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Y_SCALE, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, amount));
            return this;
        }

        public PartAnimationData scaleZ(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Z_SCALE, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, amount));
            return this;
        }

        public PartAnimationData multiplier(float multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public PartAnimationData animate(Easing ease, float animationProgress) {
            return this.multiplier(ease.apply(animationProgress));
        }

        public void apply(class_630 modelPart) {
            for (Map.Entry<PartOperationTarget, List<PartOperation>> entry : this.operations.entrySet()) {
                for (PartOperation operation : entry.getValue()) {
                    operation.apply(modelPart, entry.getKey(), this.multiplier);
                }
            }
        }

        public void apply(PoseStackResult result) {
            for (Map.Entry<PartOperationTarget, List<PartOperation>> entry : this.operations.entrySet()) {
                for (PartOperation operation : entry.getValue()) {
                    operation.apply(result, entry.getKey(), this.multiplier);
                }
            }
        }
    }

    public static enum PlayerModelPart {
        HEAD("head"),
        CHEST("chest"),
        RIGHT_ARM("right_arm"),
        LEFT_ARM("left_arm"),
        RIGHT_LEG("right_leg"),
        LEFT_LEG("left_leg"),
        BODY("body");

        private final String name;

        private PlayerModelPart(String name) {
            this.name = name;
        }

        public void applyToModelPart(class_572<?> model, PartAnimationData data) {
            if (this == HEAD) {
                data.apply(model.field_3398);
                model.field_3394.method_17138(model.field_3398);
            } else if (this == CHEST) {
                data.apply(model.field_3391);
            } else if (this == RIGHT_ARM) {
                data.apply(model.field_3401);
            } else if (this == LEFT_ARM) {
                data.apply(model.field_27433);
            } else if (this == RIGHT_LEG) {
                data.apply(model.field_3392);
            } else if (this == LEFT_LEG) {
                data.apply(model.field_3397);
            }
            if (model instanceof class_591) {
                class_591 playerModel = (class_591)model;
                playerModel.field_3483.method_17138(model.field_3391);
                playerModel.field_3486.method_17138(model.field_3401);
                playerModel.field_3484.method_17138(model.field_27433);
                playerModel.field_3479.method_17138(model.field_3392);
                playerModel.field_3482.method_17138(model.field_3397);
            }
        }

        public static PlayerModelPart fromName(String name) {
            for (PlayerModelPart part : PlayerModelPart.values()) {
                if (!part.name.equalsIgnoreCase(name)) continue;
                return part;
            }
            return null;
        }
    }

    public static enum FirstPersonContext {
        NONE,
        RIGHT_ARM,
        LEFT_ARM;


        public boolean firstPerson() {
            return this != NONE;
        }

        public boolean rightArm() {
            return this == RIGHT_ARM;
        }

        public boolean leftArm() {
            return this == LEFT_ARM;
        }

        public boolean mainArm() {
            class_746 player = class_310.method_1551().field_1724;
            return player != null && player.method_6068() == class_1306.field_6183 && this == RIGHT_ARM;
        }

        public boolean offArm() {
            class_746 player = class_310.method_1551().field_1724;
            return player != null && player.method_6068() == class_1306.field_6183 && this == LEFT_ARM;
        }
    }

    public static class Builder {
        private final Map<PlayerModelPart, PartAnimationData> animationData = new HashMap<PlayerModelPart, PartAnimationData>();
        private float limbSwing;
        private float limbSwingAmount;
        private float ageInTicks;
        private float netHeadYaw;
        private float headPitch;

        public Builder() {
        }

        public Builder(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.limbSwing = limbSwing;
            this.limbSwingAmount = limbSwingAmount;
            this.ageInTicks = ageInTicks;
            this.netHeadYaw = netHeadYaw;
            this.headPitch = headPitch;
        }

        public PartAnimationData get(PlayerModelPart modelPart) {
            if (modelPart == null) {
                throw new RuntimeException("Player model part cant be null");
            }
            return this.animationData.computeIfAbsent(modelPart, bodyPart -> new PartAnimationData());
        }

        public Map<PlayerModelPart, PartAnimationData> getAnimationData() {
            return this.animationData;
        }

        public float getLimbSwing() {
            return this.limbSwing;
        }

        public float getLimbSwingAmount() {
            return this.limbSwingAmount;
        }

        public float getAgeInTicks() {
            return this.ageInTicks;
        }

        public float getNetHeadYaw() {
            return this.netHeadYaw;
        }

        public float getHeadPitch() {
            return this.headPitch;
        }
    }
}

