/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.particleemitter;

import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_5498;
import net.minecraft.class_5819;
import net.minecraft.class_742;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.util.PerspectiveValue;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class ParticleEmitter {
    @Nullable
    private final BodyPart anchor;
    private final float amount;
    private final PerspectiveValue<Vector3f> offset;
    private final PerspectiveValue<Vector3f> offsetRandom;
    private final PerspectiveValue<Vector3f> motion;
    private final PerspectiveValue<Vector3f> motionRandom;
    private final boolean visibleInFirstPerson;

    public ParticleEmitter(@Nullable BodyPart anchor, float amount, PerspectiveValue<Vector3f> offset, PerspectiveValue<Vector3f> offsetRandom, PerspectiveValue<Vector3f> motion, PerspectiveValue<Vector3f> motionRandom, boolean visibleInFirstPerson) {
        this.anchor = anchor;
        this.amount = amount;
        this.offset = offset;
        this.offsetRandom = offsetRandom;
        this.motion = motion;
        this.motionRandom = motionRandom;
        this.visibleInFirstPerson = visibleInFirstPerson;
    }

    public static ParticleEmitter fromJson(JsonObject json) {
        BodyPart bodyPart = BodyPart.byName(class_3518.method_15253((JsonObject)json, (String)"body_part", (String)""));
        float amount = GsonUtil.getAsFloatMin(json, "amount", 0.0f, 1.0f);
        PerspectiveValue<Vector3f> offset = PerspectiveValue.getFromJson(json, "offset", j -> GsonUtil.convertToVector3f(j, "offset").div(16.0f, -16.0f, 16.0f), new Vector3f());
        PerspectiveValue<Vector3f> offsetRandom = PerspectiveValue.getFromJson(json, "offset_random", j -> GsonUtil.convertToVector3f(j, "offset_random").div(16.0f, -16.0f, 16.0f), new Vector3f());
        PerspectiveValue<Vector3f> motion = PerspectiveValue.getFromJson(json, "motion", j -> GsonUtil.convertToVector3f(j, "motion").div(16.0f, -16.0f, 16.0f), new Vector3f());
        PerspectiveValue<Vector3f> motionRandom = PerspectiveValue.getFromJson(json, "motion_random", j -> GsonUtil.convertToVector3f(j, "motion_random").div(16.0f, -16.0f, 16.0f), new Vector3f());
        boolean visibleInFirstPerson = class_3518.method_15258((JsonObject)json, (String)"visible_in_first_person", (boolean)true);
        return new ParticleEmitter(bodyPart, amount, offset, offsetRandom, motion, motionRandom, visibleInFirstPerson);
    }

    public class_243 getCenter(class_742 player, float partialTick) {
        if (this.anchor != null) {
            return BodyPart.getInWorldPosition(this.anchor, this.offset.get(), player, partialTick);
        }
        Vector3f offset = this.offset.get();
        return player.method_30950(partialTick).method_1031(0.0, (double)player.method_17682() / 2.0, 0.0).method_1031((double)offset.x, (double)offset.y, (double)offset.z);
    }

    public void spawnParticles(class_1937 level, class_742 player, class_2394 particleOptions, float partialTick) {
        if (!this.visibleInFirstPerson && player == class_310.method_1551().field_1724 && class_310.method_1551().field_1690.method_31044() == class_5498.field_26664) {
            return;
        }
        class_5819 random = class_5819.method_43047();
        if (this.amount < 1.0f) {
            if (Math.random() < (double)this.amount) {
                this.spawnParticleOnPlayer(level, player, particleOptions, random, partialTick);
            }
        } else {
            int i = 0;
            while ((float)i < this.amount) {
                this.spawnParticleOnPlayer(level, player, particleOptions, random, partialTick);
                ++i;
            }
        }
    }

    public void spawnAtPosition(class_1937 level, class_243 position, class_2394 particleOptions) {
        class_5819 random = class_5819.method_43047();
        if (this.amount < 1.0f) {
            if (Math.random() < (double)this.amount) {
                this.spawnParticleOnPosition(level, position, particleOptions, random);
            }
        } else {
            int i = 0;
            while ((float)i < this.amount) {
                this.spawnParticleOnPosition(level, position, particleOptions, random);
                ++i;
            }
        }
    }

    private void spawnParticleOnPlayer(class_1937 level, class_742 player, class_2394 particleOptions, class_5819 random, float partialTick) {
        class_243 pos;
        class_5498 cameraType = class_310.method_1551().field_1690.method_31044();
        Vector3f offset = ParticleEmitter.randomizeVector(random, this.offset.get(cameraType), this.offsetRandom.get(cameraType));
        Vector3f motion = ParticleEmitter.randomizeVector(random, this.motion.get(cameraType), this.motionRandom.get(cameraType));
        class_243 class_2432 = pos = this.anchor != null ? BodyPart.getInWorldPosition(this.anchor, offset, player, partialTick) : player.method_30950(partialTick).method_1031(0.0, (double)player.method_17682() / 2.0, 0.0).method_1031((double)offset.x, (double)offset.y, (double)offset.z);
        if (this.anchor != null) {
            Vector3f combined = new Vector3f((Vector3fc)offset).add((Vector3fc)motion);
            class_243 transformed = BodyPart.getInWorldPosition(this.anchor, combined, player, partialTick);
            class_243 motionRotated = transformed.method_1020(pos);
            level.method_8406(particleOptions, pos.field_1352, pos.field_1351, pos.field_1350, motionRotated.field_1352, motionRotated.field_1351, motionRotated.field_1350);
        } else {
            level.method_8406(particleOptions, pos.field_1352, pos.field_1351, pos.field_1350, (double)motion.x, (double)motion.y, (double)motion.z);
        }
    }

    private void spawnParticleOnPosition(class_1937 level, class_243 position, class_2394 particleOptions, class_5819 random) {
        class_5498 cameraType = class_310.method_1551().field_1690.method_31044();
        Vector3f offset = ParticleEmitter.randomizeVector(random, this.offset.get(cameraType), this.offsetRandom.get(cameraType));
        Vector3f motion = ParticleEmitter.randomizeVector(random, this.motion.get(cameraType), this.motionRandom.get(cameraType));
        class_243 pos = position.method_1031((double)offset.x, (double)(-offset.y), (double)offset.z);
        level.method_8406(particleOptions, pos.field_1352, pos.field_1351, pos.field_1350, (double)motion.x, (double)(-motion.y), (double)motion.z);
    }

    private static Vector3f randomizeVector(class_5819 random, Vector3f center, Vector3f randomOffset) {
        return new Vector3f((Vector3fc)center).add((random.method_43057() - 0.5f) * 2.0f * randomOffset.x, (random.method_43057() - 0.5f) * 2.0f * randomOffset.y, (random.method_43057() - 0.5f) * 2.0f * randomOffset.z);
    }
}

