/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.particleemitter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_3518;
import net.minecraft.class_742;
import net.threetag.palladium.client.particleemitter.ParticleEmitter;

public class ParticleEmitterConfiguration {
    private final List<ParticleEmitter> emitters;

    public ParticleEmitterConfiguration(List<ParticleEmitter> emitters) {
        this.emitters = emitters;
    }

    public void spawnParticles(class_1937 level, class_742 player, class_2394 particleOptions, float partialTick) {
        for (ParticleEmitter emitter : this.emitters) {
            emitter.spawnParticles(level, player, particleOptions, partialTick);
        }
    }

    public static ParticleEmitterConfiguration fromJson(JsonElement json) {
        if (json.isJsonArray()) {
            ArrayList<ParticleEmitter> emitterList = new ArrayList<ParticleEmitter>();
            JsonArray array = json.getAsJsonArray();
            for (JsonElement jsonElement : array) {
                emitterList.add(ParticleEmitter.fromJson(class_3518.method_15295((JsonElement)jsonElement, (String)"$[]")));
            }
            return new ParticleEmitterConfiguration(emitterList);
        }
        if (json.isJsonObject()) {
            return new ParticleEmitterConfiguration(Collections.singletonList(ParticleEmitter.fromJson(json.getAsJsonObject())));
        }
        throw new JsonSyntaxException("Particle emitter configuration must be either an object or array of multiple objects");
    }
}

