/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.entity;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_5819;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_922;
import net.threetag.palladium.client.model.animation.PalladiumAnimation;
import net.threetag.palladium.client.model.animation.PalladiumAnimationRegistry;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.entity.PlayerModelCacheExtension;
import net.threetag.palladium.mixin.client.AgeableListModelInvoker;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AnimationTimer;
import net.threetag.palladium.power.ability.VibrateAbility;
import net.threetag.palladium.util.Easing;
import org.joml.Vector3f;

public class HumanoidRendererModifications {
    public static float ALPHA_MULTIPLIER = 1.0f;
    private static float CACHED_SHRINK = 0.0f;
    public static BodyPart.ModifiedBodyPartResult CACHED_HIDE_RESULT = null;
    public static float CACHED_LIMB_SWING;
    public static float CACHED_LIMB_SWING_AMOUNT;
    public static float CACHED_AGE_IN_TICKS;
    public static float CACHED_NET_HEAD_YAW;
    public static float CACHED_HEAD_PITCH;

    public static void preSetup(class_922 renderer, class_1309 entity, class_572 model, class_4587 poseStack, float partialTicks) {
        if (model instanceof AgeableListModelInvoker) {
            AgeableListModelInvoker invoker = (AgeableListModelInvoker)model;
            PalladiumAnimationRegistry.resetPoses(invoker.invokeHeadParts(), invoker.invokeBodyParts());
        }
        if (renderer instanceof class_1007) {
            class_1007 playerRenderer = (class_1007)renderer;
            if (entity instanceof class_742) {
                class_742 player = (class_742)entity;
                PalladiumAnimation.PoseStackResult result = PalladiumAnimationRegistry.setupRotations(playerRenderer, player, poseStack, partialTicks);
                if (player instanceof PlayerModelCacheExtension) {
                    PlayerModelCacheExtension ext = (PlayerModelCacheExtension)player;
                    ext.palladium$setBodyAnimationResult(result);
                }
            }
        }
    }

    public static void preRender(class_922 renderer, class_1309 entity, class_572 model, class_4587 poseStack, float partialTick) {
        if (!PalladiumAnimationRegistry.SKIP_ANIMATIONS) {
            PalladiumAnimationRegistry.applyAnimations(model, entity, CACHED_LIMB_SWING, CACHED_LIMB_SWING_AMOUNT, CACHED_AGE_IN_TICKS, CACHED_NET_HEAD_YAW, CACHED_HEAD_PITCH);
        }
        if (!FirstPersonMode.isFirstPersonPass()) {
            BodyPart.resetBodyParts(entity, model);
        }
        CACHED_HIDE_RESULT = BodyPart.getModifiedBodyParts(entity, false);
        BodyPart.hideHiddenOrRemovedParts(model, entity, CACHED_HIDE_RESULT);
        float scale = AnimationTimer.getValue(entity, (Ability)Abilities.SHRINK_BODY_OVERLAY.get(), partialTick, Easing.INOUTSINE);
        if (scale != 0.0f) {
            float f;
            CACHED_SHRINK = f = -0.11f * scale;
            Vector3f vec = new Vector3f(f, f, f);
            for (BodyPart value : BodyPart.values()) {
                class_630 part = value.getModelPart(model);
                if (!value.isOverlay() || part == null) continue;
                part.method_41924(vec);
            }
        }
    }

    public static void preLayers(class_922 renderer, class_1309 entity, class_572 model, class_4587 poseStack) {
        if (CACHED_SHRINK != 0.0f) {
            float f = -CACHED_SHRINK;
            CACHED_SHRINK = 0.0f;
            Vector3f vec = new Vector3f(f, f, f);
            for (BodyPart value : BodyPart.values()) {
                class_630 part = value.getModelPart(model);
                if (!value.isOverlay() || part == null) continue;
                part.method_41924(vec);
            }
        }
    }

    public static void postLayers(class_922 renderer, class_1309 entity, class_572 model, class_4587 poseStack, class_4597 buffer, int packedLight, float partialTick) {
        float vibrate = AnimationTimer.getValue(entity, (Ability)Abilities.VIBRATE.get(), partialTick, Easing.INOUTSINE);
        if (vibrate > 0.0f) {
            ALPHA_MULTIPLIER = 0.3f;
            class_310 minecraft = class_310.method_1551();
            boolean bl = renderer.method_4056(entity);
            boolean bl2 = !bl && !entity.method_5756((class_1657)minecraft.field_1724);
            boolean bl3 = minecraft.method_27022((class_1297)entity);
            class_1921 renderType = renderer.method_24302(entity, bl, true, bl3);
            int intensity = VibrateAbility.getIntensity(entity);
            class_5819 rand = class_5819.method_43047();
            for (int i = 0; i < intensity; ++i) {
                poseStack.method_22903();
                poseStack.method_46416((rand.method_43057() - 0.5f) / 15.0f * vibrate, 0.0f, (rand.method_43057() - 0.5f) / 15.0f * vibrate);
                if (renderType != null) {
                    class_4588 vertexConsumer = buffer.getBuffer(renderType);
                    int m = class_922.method_23622((class_1309)entity, (float)renderer.method_23185(entity, partialTick));
                    renderer.method_4038().method_2828(poseStack, vertexConsumer, packedLight, m, 1.0f, 1.0f, 1.0f, bl2 ? 0.15f : 1.0f);
                }
                poseStack.method_22909();
                poseStack.method_22903();
                poseStack.method_46416((rand.method_43057() - 0.5f) / 7.0f * vibrate, 0.0f, (rand.method_43057() - 0.5f) / 7.0f * vibrate);
                if (!entity.method_7325()) {
                    for (Object layer : renderer.field_4738) {
                        if (!(layer instanceof class_3887)) continue;
                        class_3887 renderLayer = (class_3887)layer;
                        renderLayer.method_4199(poseStack, buffer, packedLight, (class_1297)entity, CACHED_LIMB_SWING, CACHED_LIMB_SWING_AMOUNT, partialTick, CACHED_AGE_IN_TICKS, CACHED_NET_HEAD_YAW, CACHED_HEAD_PITCH);
                    }
                }
                poseStack.method_22909();
            }
            ALPHA_MULTIPLIER = 1.0f;
        }
        if (entity instanceof PlayerModelCacheExtension) {
            PlayerModelCacheExtension ext = (PlayerModelCacheExtension)entity;
            for (BodyPart part : BodyPart.values()) {
                class_630 orig = part.getModelPart(model);
                class_630 cache = part.getModelPart((class_572<?>)ext.palladium$getCachedModel());
                if (orig == null || cache == null) continue;
                cache.method_32085(orig.method_32084());
            }
        }
    }

    public static void applyRemovedBodyParts(class_572 model) {
        BodyPart.ModifiedBodyPartResult hideResult = CACHED_HIDE_RESULT;
        if (hideResult == null) {
            return;
        }
        if (hideResult.isRemoved(BodyPart.HEAD)) {
            model.field_3394.field_3665 = false;
            model.field_3398.field_3665 = false;
        }
        if (hideResult.isRemoved(BodyPart.CHEST)) {
            model.field_3391.field_3665 = false;
        }
        if (hideResult.isRemoved(BodyPart.RIGHT_ARM)) {
            model.field_3401.field_3665 = false;
        }
        if (hideResult.isRemoved(BodyPart.LEFT_ARM)) {
            model.field_27433.field_3665 = false;
        }
        if (hideResult.isRemoved(BodyPart.RIGHT_LEG)) {
            model.field_3392.field_3665 = false;
        }
        if (hideResult.isRemoved(BodyPart.LEFT_LEG)) {
            model.field_3397.field_3665 = false;
        }
    }
}

