/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.item.armor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3518;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import net.threetag.palladium.client.renderer.renderlayer.ModelTypes;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class ArmorModelData {
    private final Map<String, SkinTypedValue<class_5601>> modelByKey = new HashMap<String, SkinTypedValue<class_5601>>();
    private final Map<String, SkinTypedValue<class_572<?>>> generatedByKey = new HashMap();

    public ArmorModelData add(String key, SkinTypedValue<class_5601> texture) {
        this.modelByKey.put(key, texture);
        return this;
    }

    @Nullable
    public class_572<?> get(String key, class_1309 entity, boolean hasConditions) {
        if (!hasConditions) {
            SkinTypedValue<class_572<?>> fallback = this.generatedByKey.get("default");
            return fallback != null ? fallback.get((class_1297)entity) : null;
        }
        SkinTypedValue<class_572<?>> data = this.generatedByKey.get(key);
        if (data == null) {
            throw new IllegalStateException("Unknown model key for armor: #" + key);
        }
        return data.get((class_1297)entity);
    }

    public boolean has(String key) {
        return this.modelByKey.containsKey(key);
    }

    public void buildModels(ModelTypes.Model modelType, class_5599 modelSet) {
        this.modelByKey.forEach((key, layer) -> {
            class_572 normal = (class_572)modelType.getModel(modelSet.method_32072((class_5601)layer.getNormal()));
            if (((class_5601)layer.getNormal()).equals(layer.getSlim())) {
                this.generatedByKey.put((String)key, (SkinTypedValue<class_572<?>>)new SkinTypedValue<class_572>(normal));
            } else {
                class_572 slim = (class_572)modelType.getModel(modelSet.method_32072((class_5601)layer.getSlim()));
                this.generatedByKey.put((String)key, (SkinTypedValue<class_572<?>>)new SkinTypedValue<class_572>(normal, slim));
            }
        });
    }

    public static ArmorModelData fromJson(JsonElement json) {
        ArmorModelData data = new ArmorModelData();
        if (json == null) {
            return data.add("default", new SkinTypedValue<class_5601>(class_5602.field_27677));
        }
        if (json.isJsonPrimitive() || json.isJsonObject() && json.getAsJsonObject().entrySet().size() == 2 && class_3518.method_15294((JsonObject)json.getAsJsonObject(), (String)"normal") && class_3518.method_15294((JsonObject)json.getAsJsonObject(), (String)"slim")) {
            SkinTypedValue<class_5601> texture = SkinTypedValue.fromJSON(json, j -> GsonUtil.convertToModelLayerLocation(j, "model_layers"));
            data.add("default", texture);
        } else if (json.isJsonObject()) {
            JsonObject object = class_3518.method_15295((JsonElement)json, (String)"model_layers");
            for (Map.Entry e : object.entrySet()) {
                String key = (String)e.getKey();
                JsonElement textureJson = (JsonElement)e.getValue();
                data.add(key, SkinTypedValue.fromJSON(textureJson, j -> GsonUtil.convertToModelLayerLocation(j, "model_layers")));
            }
        } else {
            throw new JsonParseException("Model layers must be json primitive or json object");
        }
        return data;
    }
}

