/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.RenderLayerStates;
import net.threetag.palladium.entity.PalladiumLivingEntityExtension;
import net.threetag.palladium.util.RenderUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class LightningSparksRenderLayer
extends AbstractPackRenderLayer {
    private final float frequency;
    private final int amount;
    private final DynamicColor coreColor;
    private final DynamicColor glowColor;
    private final float coreOpacity;
    private final float glowOpacity;
    private final float thickness;
    private final float scale;
    private final boolean normalTransparency;

    public LightningSparksRenderLayer(float frequency, int amount, DynamicColor coreColor, DynamicColor glowColor, float coreOpacity, float glowOpacity, float thickness, float scale, boolean normalTransparency) {
        this.frequency = frequency;
        this.amount = amount;
        this.coreColor = coreColor;
        this.glowColor = glowColor;
        this.coreOpacity = coreOpacity;
        this.glowOpacity = glowOpacity;
        this.thickness = thickness;
        this.scale = scale;
        this.normalTransparency = normalTransparency;
    }

    public static LightningSparksRenderLayer parse(JsonObject json) {
        float frequency = GsonUtil.getAsFloatRanged(json, "frequency", 0.0f, 1.0f, 0.5f);
        int amount = GsonUtil.getAsIntMin(json, "amount", 0, 5);
        DynamicColor coreColor = DynamicColor.getFromJson(json, "core_color", DynamicColor.WHITE);
        DynamicColor glowColor = DynamicColor.getFromJson(json, "glow_color", DynamicColor.WHITE);
        float coreOpacity = GsonUtil.getAsFloatRanged(json, "core_opacity", 0.0f, 1.0f, 1.0f);
        float glowOpacity = GsonUtil.getAsFloatRanged(json, "glow_opacity", 0.0f, 1.0f, 1.0f);
        float thickness = GsonUtil.getAsFloatMin(json, "thickness", 0.001f, 0.02f);
        float scale = GsonUtil.getAsFloatMin(json, "scale", 0.0f, 1.0f);
        boolean normalTransparency = class_3518.method_15258((JsonObject)json, (String)"normal_transparency", (boolean)false);
        return new LightningSparksRenderLayer(frequency, amount, coreColor, glowColor, coreOpacity, glowOpacity, thickness, scale, normalTransparency);
    }

    @Override
    public void render(DataContext context, class_4587 poseStack, class_4597 bufferSource, class_583<class_1297> parentModel, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        class_1309 entity = context.getLivingEntity();
        State state = this.getState(entity);
        if (state != null && entity != null) {
            class_4588 vertexConsumer = bufferSource.getBuffer(this.normalTransparency ? PalladiumRenderTypes.LASER_NORMAL_TRANSPARENCY : PalladiumRenderTypes.LASER);
            for (Spark spark : state.sparks) {
                float opacity = 1.0f - class_3532.method_15363((float)(((float)spark.ticks + partialTicks) / 4.0f), (float)0.0f, (float)1.0f);
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 1.5f, 0.0f);
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
                poseStack.method_46416(entity.method_17681() * this.scale / -2.0f, entity.method_17682() / 2.0f - entity.method_17682() * this.scale / 2.0f, entity.method_17681() * this.scale / -2.0f);
                LightningSparksRenderLayer.renderLightning(poseStack, vertexConsumer, spark.pos1, spark.pos2, this.coreColor.getColor(context), this.glowColor.getColor(context), opacity * this.coreOpacity, opacity * this.glowOpacity, this.thickness);
                LightningSparksRenderLayer.renderLightning(poseStack, vertexConsumer, spark.pos1, spark.pos3, this.coreColor.getColor(context), this.glowColor.getColor(context), opacity * this.coreOpacity, opacity * this.glowOpacity, this.thickness);
                poseStack.method_22909();
            }
        }
    }

    private static void renderLightning(class_4587 poseStack, class_4588 consumer, class_243 start, class_243 end, Color coreColor, Color glowColor, float coreOpacity, float glowOpacity, float thickness) {
        poseStack.method_22903();
        poseStack.method_22904(start.field_1352, start.field_1351, start.field_1350);
        RenderUtil.faceVec(poseStack, start, end);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        class_238 box = new class_238((double)(-thickness / 2.0f), 0.0, (double)(-thickness / 2.0f), (double)(thickness / 2.0f), start.method_1022(end), (double)(thickness / 2.0f));
        RenderUtil.renderFilledBox(poseStack, consumer, box, (float)coreColor.getRed() / 255.0f, (float)coreColor.getGreen() / 255.0f, (float)coreColor.getBlue() / 255.0f, coreOpacity, 0xF00000);
        RenderUtil.renderFilledBox(poseStack, consumer, box.method_1014(0.03125), (float)glowColor.getRed() / 255.0f, (float)glowColor.getGreen() / 255.0f, (float)glowColor.getBlue() / 255.0f, 0.5f * glowOpacity, 0xF00000);
        poseStack.method_22909();
    }

    @Nullable
    public State getState(class_1309 entity) {
        if (entity instanceof PalladiumLivingEntityExtension) {
            State state;
            PalladiumLivingEntityExtension extension = (PalladiumLivingEntityExtension)entity;
            RenderLayerStates.State state2 = extension.palladium$getRenderLayerStates().getOrCreate(this);
            return state2 instanceof State ? (state = (State)state2) : null;
        }
        return null;
    }

    @Override
    public RenderLayerStates.State createState() {
        return new State(this);
    }

    public static class State
    extends RenderLayerStates.State {
        private final LightningSparksRenderLayer layer;
        private List<Spark> sparks = new ArrayList<Spark>();

        public State(LightningSparksRenderLayer layer) {
            this.layer = layer;
        }

        @Override
        public void tick(class_1309 entity) {
            super.tick(entity);
            this.sparks.forEach(Spark::tick);
            this.sparks = this.sparks.stream().peek(Spark::tick).filter(s -> s.ticks < 5).collect(Collectors.toList());
            if (this.sparks.isEmpty() && IPackRenderLayer.conditionsFulfilled((class_1297)entity, this.layer.conditions, this.layer.thirdPersonConditions) && Math.random() < (double)this.layer.frequency) {
                for (int i = 0; i < this.layer.amount; ++i) {
                    this.sparks.add(new Spark((class_1297)entity, this.layer.scale, class_5819.method_43047()));
                }
            }
        }
    }

    public static class Spark {
        public final class_243 pos1;
        public final class_243 pos2;
        public final class_243 pos3;
        private int ticks;

        public Spark(class_1297 entity, float scale, class_5819 randomSource) {
            Random random = new Random();
            this.pos1 = new class_243((double)(entity.method_17681() * scale * random.nextFloat()), (double)(entity.method_17682() * scale * random.nextFloat()), (double)(entity.method_17681() * scale * random.nextFloat()));
            this.pos2 = this.makePos(this.pos1, entity.method_17681() * scale, entity.method_17682() * scale, randomSource);
            this.pos3 = this.makePos(this.pos1, entity.method_17681() * scale, entity.method_17682() * scale, randomSource);
        }

        private class_243 makePos(class_243 center, float width, float height, class_5819 source) {
            float length = (width + height) / 20.0f;
            float x = (float)class_3532.method_15350((double)(center.field_1352 + (double)((source.method_43057() * 2.0f - 1.0f) * length)), (double)0.0, (double)width);
            float y = (float)class_3532.method_15350((double)(center.field_1351 + (double)((source.method_43057() * 2.0f - 1.0f) * length)), (double)0.0, (double)height);
            float z = (float)class_3532.method_15350((double)(center.field_1350 + (double)((source.method_43057() * 2.0f - 1.0f) * length)), (double)0.0, (double)width);
            return new class_243((double)x, (double)y, (double)z);
        }

        private void tick() {
            ++this.ticks;
        }
    }
}

