/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.trail;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.entity.HumanoidRendererModifications;
import net.threetag.palladium.client.renderer.entity.TrailSegmentEntityRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRendererManager;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.entity.TrailSegmentEntity;
import net.threetag.palladium.util.json.GsonUtil;

public class AfterImageTrailRenderer
extends TrailRenderer<TrailRenderer.SegmentCache> {
    public static final class_2960 TEXTURE = Palladium.id("textures/entity/trail.png");
    private final DynamicColor color;
    public final boolean mimicPlayer;
    private final float spacing;
    private final int lifetime;
    private final float opacity;

    public AfterImageTrailRenderer(DynamicColor color, boolean mimicPlayer, float spacing, int lifetime, float opacity) {
        this.color = color;
        this.mimicPlayer = mimicPlayer;
        this.spacing = spacing;
        this.lifetime = lifetime;
        this.opacity = opacity;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, TrailSegmentEntityRenderer trailRenderer, class_1297 livingEntity, TrailSegmentEntity<TrailRenderer.SegmentCache> segment, float partialTick, float entityYaw) {
        HumanoidRendererModifications.ALPHA_MULTIPLIER = (1.0f - (float)segment.field_6012 / (float)segment.lifetime) * this.opacity;
        trailRenderer.renderModel(segment, entityYaw, segment.partialTick, poseStack, buffer, packedLight);
        HumanoidRendererModifications.ALPHA_MULTIPLIER = 1.0f;
    }

    @Override
    public DynamicColor getColor() {
        return this.color;
    }

    @Override
    public float getSpacing() {
        return this.spacing;
    }

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    public static class Serializer
    implements TrailRendererManager.TypeSerializer {
        @Override
        public TrailRenderer<?> parse(JsonObject json) {
            DynamicColor color = DynamicColor.getFromJson(json, "color", DynamicColor.WHITE);
            boolean mimicPlayer = class_3518.method_15258((JsonObject)json, (String)"mimic_player", (boolean)false);
            float spacing = GsonUtil.getAsFloatMin(json, "spacing", 0.1f, 1.0f);
            int lifetime = GsonUtil.getAsIntMin(json, "lifetime", 1, 20);
            float opacity = GsonUtil.getAsFloatRanged(json, "opacity", 0.0f, 1.0f, 0.5f);
            return new AfterImageTrailRenderer(color, mimicPlayer, spacing, lifetime, opacity);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("After Image Trail");
            builder.setDescription("Spawns copies of you as a trail.");
            builder.addProperty("color", Color.class).description("Determines the tint/color of the after image").fallback(Color.WHITE, "#ffffff").exampleJson((JsonElement)new JsonPrimitive("#ffffff"));
            builder.addProperty("mimic_player", Boolean.class).description("If enabled, the after image will copy the player's skin and armor").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            builder.addProperty("spacing", Float.class).description("Determines the space between two trail segments").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("lifetime", Integer.class).description("Determines how long one trail segment stays alive (in ticks)").fallback(20).exampleJson((JsonElement)new JsonPrimitive((Number)20));
            builder.addProperty("opacity", Float.class).description("Determines the (initial) opacity of the after image.").fallback(Float.valueOf(0.5f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(0.5f)));
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("after_image");
        }
    }
}

