/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.util.collection.IntObjectHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.threetag.palladium.PalladiumConfig;
import net.threetag.palladium.client.PalladiumKeyMappings;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityColor;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.energybar.EnergyBar;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladiumcore.event.ClientTickEvents;
import net.threetag.palladiumcore.registry.client.OverlayRegistry;

public class AbilityBarRenderer
implements OverlayRegistry.IngameOverlay {
    public static final class_2960 TEXTURE = new class_2960("palladium", "textures/gui/ability_bar.png");
    public static List<AbilityList> ABILITY_LISTS = new ArrayList<AbilityList>();
    public static int SELECTED = 0;

    public AbilityBarRenderer() {
        ClientTickEvents.CLIENT_POST.register(instance -> AbilityBarRenderer.updateCurrentLists());
    }

    public static AbilityList getSelectedList() {
        if (ABILITY_LISTS.isEmpty()) {
            return null;
        }
        if (SELECTED >= ABILITY_LISTS.size() || SELECTED < 0) {
            SELECTED = 0;
        }
        return ABILITY_LISTS.get(SELECTED);
    }

    public void render(class_310 mc, class_329 gui, class_332 guiGraphics, float partialTicks, int width, int height) {
        boolean simple;
        if (ABILITY_LISTS.isEmpty()) {
            return;
        }
        class_4587 poseStack = guiGraphics.method_51448();
        Position position = (Position)((Object)PalladiumConfig.Client.ABILITY_BAR_POSITION.get());
        AbilityList list = AbilityBarRenderer.getSelectedList();
        if (position == Position.HIDDEN || list == null) {
            return;
        }
        if (position.top && mc.field_1690.field_1866) {
            return;
        }
        if (!position.top && mc.field_1755 instanceof class_408) {
            position = position.left ? Position.TOP_LEFT : Position.TOP_RIGHT;
        }
        boolean bl = simple = list.simple && ABILITY_LISTS.size() <= 1;
        if (mc.field_1724 != null) {
            class_2960 texture = list.texture != null ? list.texture : TEXTURE;
            int indicatorWidth = 52;
            int indicatorHeight = 28;
            if (!simple) {
                poseStack.method_22903();
                AbilityBarRenderer.translateIndicatorBackground(poseStack, mc.method_22683(), position, indicatorWidth, indicatorHeight);
                AbilityBarRenderer.renderIndicator(list, mc, guiGraphics, poseStack, position, texture, ABILITY_LISTS.size() > 1);
                poseStack.method_22909();
            }
            if (!list.energyBars.isEmpty()) {
                poseStack.method_22903();
                AbilityBarRenderer.translateEnergyBars(poseStack, mc.method_22683(), position, indicatorHeight, 24, list.energyBars.size());
                AbilityBarRenderer.renderEnergyBars(guiGraphics, list, texture);
                poseStack.method_22909();
            }
            poseStack.method_22903();
            AbilityBarRenderer.translateAbilitiesBackground(poseStack, mc.method_22683(), position, indicatorHeight, 24, 112, simple);
            AbilityBarRenderer.renderAbilitiesBackground(mc, guiGraphics, poseStack, position, list, texture, simple);
            AbilityBarRenderer.renderAbilitiesOverlay(mc, guiGraphics, poseStack, position, list, texture, simple);
            poseStack.method_22909();
        }
    }

    private static void translateIndicatorBackground(class_4587 poseStack, class_1041 window, Position position, int width, int height) {
        if (!position.top) {
            poseStack.method_46416(0.0f, (float)(window.method_4502() - height), 0.0f);
        }
        if (!position.left) {
            poseStack.method_46416((float)(window.method_4486() - width), 0.0f, 0.0f);
        }
    }

    private static void renderIndicator(AbilityList list, class_310 minecraft, class_332 guiGraphics, class_4587 poseStack, Position position, class_2960 texture, boolean showKey) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25302(texture, 0, 0, position.left ? 52 : 0, position.top ? 28 : 0, 52, 28);
        list.power.getIcon().draw(minecraft, guiGraphics, DataContext.forPower((class_1309)minecraft.field_1724, list.getPowerHolder()), showKey ? (position.left ? 30 : 6) : (position.left ? 17 : 19), position.top ? 5 : 7);
        if (showKey) {
            class_5348 properties = minecraft.field_1772.method_1714((class_5348)PalladiumKeyMappings.SWITCH_ABILITY_LIST.method_16007(), 10);
            int length = minecraft.field_1772.method_27525(properties) + 10;
            guiGraphics.method_51439(minecraft.field_1772, (class_2561)class_2561.method_43470((String)properties.getString()), (int)((float)(position.left ? 15 : 37) - (float)length / 2.0f + 10.0f), position.top ? 10 : 12, -1, false);
            guiGraphics.method_25302(texture, (position.left ? 15 : 37) - length / 2, position.top ? 9 : 11, 78, minecraft.field_1724.method_18276() ? 64 : 56, 8, 8);
        }
    }

    private static void translateAbilitiesBackground(class_4587 poseStack, class_1041 window, Position position, int indicatorHeight, int abilitiesWidth, int abilitiesHeight, boolean simple) {
        if (!simple) {
            if (position.top) {
                poseStack.method_46416(!position.left ? (float)(window.method_4486() - abilitiesWidth) : 0.0f, (float)(indicatorHeight - 1), 0.0f);
            } else {
                poseStack.method_46416(!position.left ? (float)(window.method_4486() - abilitiesWidth) : 0.0f, (float)(window.method_4502() - indicatorHeight - abilitiesHeight + 1), 0.0f);
            }
        } else if (position.top) {
            poseStack.method_46416(!position.left ? (float)(window.method_4486() - abilitiesWidth) : 0.0f, 0.0f, 0.0f);
        } else {
            poseStack.method_46416(!position.left ? (float)(window.method_4486() - abilitiesWidth) : 0.0f, (float)(window.method_4502() - 24), 0.0f);
        }
    }

    private static void renderAbilitiesBackground(class_310 minecraft, class_332 guiGraphics, class_4587 poseStack, Position position, AbilityList list, class_2960 texture, boolean simple) {
        boolean showName = minecraft.field_1755 instanceof class_408;
        for (int i = 0; !(i >= 5 || simple && i > 0); ++i) {
            class_308.method_24211();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.method_25302(texture, 3, i * 22 + 3, 60, 56, 18, 18);
            if (list == null) continue;
            AbilityInstance entry = list.getDisplayedAbilities()[i];
            if (entry != null) {
                if (entry.isEnabled() && entry.activationTimer != 0 && entry.maxActivationTimer != 0) {
                    int height = (int)((float)entry.activationTimer / (float)entry.maxActivationTimer * 18.0f);
                    guiGraphics.method_25302(texture, 3, i * 22 + 3, 24, 56, 18, 18);
                    guiGraphics.method_25302(texture, 3, i * 22 + 3 + (18 - height), 42, 74 - height, 18, height);
                } else {
                    guiGraphics.method_25302(texture, 3, i * 22 + 3, entry.isEnabled() ? 42 : 24, entry.isUnlocked() ? 56 : 74, 18, 18);
                }
                if (entry.cooldown > 0) {
                    int width = (int)((float)entry.cooldown / (float)entry.maxCooldown * 18.0f);
                    guiGraphics.method_25302(texture, 3, i * 22 + 3, 60, 74, width, 18);
                }
                if (!entry.isUnlocked()) {
                    guiGraphics.method_25302(texture, 3, i * 22 + 3, 42, 74, 18, 18);
                } else {
                    entry.getProperty(Ability.ICON).draw(minecraft, guiGraphics, DataContext.forAbility((class_1309)minecraft.field_1724, entry), 4, 4 + i * 22);
                }
                if (!showName) continue;
                class_289 tes = class_289.method_1348();
                class_287 bb = tes.method_1349();
                class_2561 name = entry.getConfiguration().getDisplayName();
                int width = minecraft.field_1772.method_27525((class_5348)name);
                AbilityBarRenderer.renderBlackBox(bb, tes, poseStack, position.left ? 24 : -width - 10, i * 22 + 5, 10 + width, 14, 0.5f);
                guiGraphics.method_51439(minecraft.field_1772, name, position.left ? 29 : -width - 5, i * 22 + 8, -1, false);
                continue;
            }
            guiGraphics.method_25302(texture, 3, i * 22 + 3, 60, 56, 18, 18);
        }
    }

    private static void renderAbilitiesOverlay(class_310 minecraft, class_332 guiGraphics, class_4587 poseStack, Position position, AbilityList list, class_2960 texture, boolean simple) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!simple) {
            guiGraphics.method_25302(texture, 0, 0, 0, 56, 24, 112);
        } else {
            guiGraphics.method_25302(texture, 0, 0, 0, 168, 24, 24);
        }
        for (int i = 0; i < 5; ++i) {
            AbilityInstance ability = list.getDisplayedAbilities()[i];
            if (ability == null) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_308.method_24211();
            RenderSystem.enableBlend();
            if (!ability.isUnlocked()) {
                guiGraphics.method_25302(texture, 3, i * 22 + 3, 42, 74, 18, 18);
            }
            AbilityColor color = ability.getProperty(Ability.COLOR);
            guiGraphics.method_25302(texture, 0, i * 22, color.getX(), color.getY(), 24, 24);
            if (!ability.getConfiguration().needsKey() || !ability.isUnlocked()) continue;
            AbilityConfiguration.KeyType keyType = ability.getConfiguration().getKeyType();
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 200.0f);
            if (keyType == AbilityConfiguration.KeyType.KEY_BIND) {
                class_2561 key = PalladiumKeyMappings.ABILITY_KEYS[i].method_16007();
                guiGraphics.method_51439(minecraft.field_1772, key, 22 - minecraft.field_1772.method_27525((class_5348)key), 5 + i * 22 + 7, 0xFFFFFF, false);
            } else if (keyType == AbilityConfiguration.KeyType.LEFT_CLICK) {
                guiGraphics.method_25302(texture, 16, 5 + i * 22 + 8, 24, 92, 5, 7);
            } else if (keyType == AbilityConfiguration.KeyType.RIGHT_CLICK) {
                guiGraphics.method_25302(texture, 16, 5 + i * 22 + 8, 29, 92, 5, 7);
            } else if (keyType == AbilityConfiguration.KeyType.SPACE_BAR) {
                guiGraphics.method_25302(texture, 11, 5 + i * 22 + 10, 34, 92, 10, 5);
            } else if (keyType == AbilityConfiguration.KeyType.SCROLL_UP) {
                guiGraphics.method_25302(texture, 16, 5 + i * 22 + 4, 24, 99, 5, 11);
            } else if (keyType == AbilityConfiguration.KeyType.SCROLL_DOWN) {
                guiGraphics.method_25302(texture, 16, 5 + i * 22 + 4, 29, 99, 5, 11);
            } else if (keyType == AbilityConfiguration.KeyType.SCROLL_EITHER) {
                guiGraphics.method_25302(texture, 16, 5 + i * 22 + 2, 34, 99, 5, 13);
            }
            poseStack.method_22909();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void translateEnergyBars(class_4587 poseStack, class_1041 window, Position position, int indicatorHeight, int abilitiesWidth, int energyBarAmount) {
        int width = energyBarAmount * 9 + 1;
        int height = 104;
        if (position.top) {
            poseStack.method_46416(!position.left ? (float)(window.method_4486() - abilitiesWidth - width + 1) : (float)(abilitiesWidth - 1), (float)(indicatorHeight - 1), 0.0f);
        } else {
            poseStack.method_46416(!position.left ? (float)(window.method_4486() - abilitiesWidth - width + 1) : (float)(abilitiesWidth - 1), (float)(window.method_4502() - indicatorHeight - height + 1), 0.0f);
        }
    }

    public static void renderEnergyBars(class_332 guiGraphics, AbilityList list, class_2960 texture) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25302(texture, 0, 0, 152, 0, 1, 104);
        int x = 1;
        for (EnergyBar energyBar : list.energyBars) {
            guiGraphics.method_25302(texture, x, 0, 153, 0, 9, 104);
            int height = (int)((float)energyBar.get() / (float)energyBar.getMax() * 98.0f);
            Color color = energyBar.getConfiguration().getColor();
            RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            guiGraphics.method_25302(texture, x + 2, 101 - height, 162, 98 - height, 4, height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            x += 9;
        }
    }

    public static void renderBlackBox(class_287 bb, class_289 tesselator, class_4587 matrixStack, int x, int y, int width, int height, float opacity) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bb.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bb.method_22918(matrixStack.method_23760().method_23761(), (float)(x + width), (float)y, 0.0f).method_22915(0.0f, 0.0f, 0.0f, opacity).method_1344();
        bb.method_22918(matrixStack.method_23760().method_23761(), (float)x, (float)y, 0.0f).method_22915(0.0f, 0.0f, 0.0f, opacity).method_1344();
        bb.method_22918(matrixStack.method_23760().method_23761(), (float)x, (float)(y + height), 0.0f).method_22915(0.0f, 0.0f, 0.0f, opacity).method_1344();
        bb.method_22918(matrixStack.method_23760().method_23761(), (float)(x + width), (float)(y + height), 0.0f).method_22915(0.0f, 0.0f, 0.0f, opacity).method_1344();
        tesselator.method_1350();
        RenderSystem.disableBlend();
    }

    public static void updateCurrentLists() {
        if (class_310.method_1551() != null && class_310.method_1551().field_1724 != null && SELECTED >= (ABILITY_LISTS = AbilityBarRenderer.getAbilityLists()).size()) {
            SELECTED = ABILITY_LISTS.size() - 1;
        }
    }

    public static void scroll(boolean up) {
        SELECTED = up ? ++SELECTED : --SELECTED;
        if (SELECTED >= ABILITY_LISTS.size()) {
            SELECTED = 0;
        } else if (SELECTED < 0) {
            SELECTED = ABILITY_LISTS.size() - 1;
        }
    }

    public static List<AbilityList> getAbilityLists() {
        ArrayList<AbilityList> lists = new ArrayList<AbilityList>();
        IPowerHandler handler = PowerManager.getPowerHandler((class_1309)class_310.method_1551().field_1724).orElse(null);
        if (handler == null) {
            return lists;
        }
        for (IPowerHolder holder : handler.getPowerHolders().values()) {
            ArrayList<AbilityList> containerList = new ArrayList<AbilityList>();
            ArrayList<AbilityList> remainingLists = new ArrayList<AbilityList>();
            ArrayList<AbilityInstance> remaining = new ArrayList<AbilityInstance>();
            for (AbilityInstance abilityInstance : holder.getAbilities().values()) {
                int i = abilityInstance.getProperty(Ability.LIST_INDEX);
                if (!abilityInstance.getConfiguration().needsKey() || abilityInstance.getProperty(Ability.HIDDEN_IN_BAR).booleanValue()) continue;
                if (i >= 0) {
                    int listIndex = Math.floorDiv(i, 5);
                    int index = i % 5;
                    while (containerList.size() - 1 < listIndex) {
                        containerList.add(new AbilityList(holder));
                    }
                    AbilityList abilityList = (AbilityList)containerList.get(listIndex);
                    abilityList.addAbility(index, abilityInstance);
                    continue;
                }
                remaining.add(abilityInstance);
            }
            for (int i = 0; i < remaining.size(); ++i) {
                AbilityInstance abilityInstance;
                abilityInstance = (AbilityInstance)remaining.get(i);
                int listIndex = Math.floorDiv(i, 5);
                int index = i % 5;
                while (remainingLists.size() - 1 < listIndex) {
                    remainingLists.add(new AbilityList(holder));
                }
                AbilityList abilityList = (AbilityList)remainingLists.get(listIndex);
                abilityList.addAbility(index, abilityInstance);
            }
            for (AbilityList list : containerList) {
                if (list.isEmpty() || list.isFullyLocked()) continue;
                lists.add(list);
            }
            for (AbilityList list : remainingLists) {
                if (list.isEmpty() || list.isFullyLocked()) continue;
                lists.add(list);
            }
        }
        if (lists.size() <= 1) {
            lists.forEach(AbilityList::simplify);
        }
        return lists;
    }

    public static class AbilityList {
        private static final int SIZE = 5;
        private final IPowerHolder powerHolder;
        private final Power power;
        private final IntObjectHashMap<List<AbilityInstance>> abilities = new IntObjectHashMap();
        private final class_2960 texture;
        public boolean simple = false;
        private final Collection<EnergyBar> energyBars;

        public AbilityList(IPowerHolder powerHolder) {
            this.powerHolder = powerHolder;
            this.power = powerHolder.getPower();
            TextureReference powerTex = this.power.getAbilityBarTexture();
            this.texture = powerTex != null ? powerTex.getTexture(DataContext.forPower((class_1309)class_310.method_1551().field_1724, this.powerHolder)) : null;
            this.energyBars = powerHolder.getEnergyBars().values();
        }

        public IPowerHolder getPowerHolder() {
            return this.powerHolder;
        }

        public Power getPower() {
            return this.power;
        }

        public Collection<EnergyBar> getEnergyBars() {
            return this.energyBars;
        }

        public AbilityList addAbility(int index, AbilityInstance ability) {
            ((List)this.abilities.computeIfAbsent((Object)index, integer -> new ArrayList())).add(ability);
            return this;
        }

        public boolean addAbility(AbilityInstance ability) {
            for (int i = 0; i < 5; ++i) {
                if (this.abilities.get(i) != null && !((List)this.abilities.get(i)).isEmpty()) continue;
                ((List)this.abilities.computeIfAbsent((Object)i, integer -> new ArrayList())).add(ability);
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            for (int i = 0; i < 5; ++i) {
                if (this.abilities.get(i) == null || ((List)this.abilities.get(i)).isEmpty()) continue;
                return false;
            }
            return true;
        }

        public boolean isFullyLocked() {
            for (AbilityInstance entry : this.getDisplayedAbilities()) {
                if (entry == null || !entry.isUnlocked()) continue;
                return false;
            }
            return true;
        }

        public AbilityInstance[] getDisplayedAbilities() {
            AbilityInstance[] entries = new AbilityInstance[5];
            for (int i = 0; i < 5; ++i) {
                if (this.abilities.get(i) == null) continue;
                for (AbilityInstance entry : (List)this.abilities.get(i)) {
                    AbilityInstance current = entries[i];
                    if (current == null) {
                        entries[i] = entry;
                        continue;
                    }
                    if (current.isUnlocked() || !entry.isUnlocked()) continue;
                    entries[i] = entry;
                }
            }
            return entries;
        }

        public void simplify() {
            if (!this.power.allowBarShrinking() || !this.energyBars.isEmpty()) {
                return;
            }
            int abilities = 0;
            AbilityInstance entry = null;
            for (AbilityInstance ability : this.getDisplayedAbilities()) {
                if (ability == null || !ability.isUnlocked()) continue;
                ++abilities;
                entry = ability;
            }
            boolean bl = this.simple = abilities == 1;
            if (this.simple) {
                this.abilities.clear();
                this.addAbility(0, entry);
            }
        }
    }

    public static enum Position {
        TOP_LEFT(true, true),
        TOP_RIGHT(false, true),
        BOTTOM_LEFT(true, false),
        BOTTOM_RIGHT(false, false),
        HIDDEN(false, false);

        private final boolean left;
        private final boolean top;

        private Position(boolean left, boolean top) {
            this.left = left;
            this.top = top;
        }
    }
}

