/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen.power;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1309;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.client.screen.power.PowerTab;
import net.threetag.palladium.client.screen.power.PowerTabType;
import net.threetag.palladium.client.screen.power.PowersScreen;
import net.threetag.palladium.network.RequestAbilityBuyScreenMessage;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityDescription;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.Nullable;

public class ListPowerTab
extends PowerTab {
    private AbilityList list;
    private AbilityInstance hovered;

    protected ListPowerTab(class_310 minecraft, PowersScreen screen, PowerTabType type, int tabIndex, IPowerHolder powerHolder) {
        super(minecraft, screen, type, tabIndex, powerHolder);
    }

    @Override
    public void populate() {
        int i = (this.screen.field_22789 - 252) / 2;
        int j = (this.screen.field_22790 - 196) / 2;
        this.list = new AbilityList(this.minecraft, this, 234, 169, i + 9, j + 18, 30);
        this.list.populate(this.powerHolder);
    }

    @Override
    public void onOpened() {
        this.populate();
        if (this.list != null) {
            this.screen.method_25429((class_364)this.list);
        }
    }

    @Override
    public void onClosed() {
        if (this.list != null) {
            this.screen.method_37066((class_364)this.list);
        }
    }

    @Override
    public void drawContents(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTick) {
        TextureReference backgroundTexture = this.powerHolder.getPower().getBackground();
        class_2960 texture = backgroundTexture != null ? backgroundTexture.getTexture(DataContext.forPower((class_1309)this.minecraft.field_1724, this.powerHolder)) : new class_2960("textures/block/red_wool.png");
        for (int m = -1; m <= 13; ++m) {
            for (int n = -1; n <= 9; ++n) {
                guiGraphics.method_25290(texture, x + 10 + 16 * m, y + 10 + 16 * n, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        this.hovered = null;
        if (this.list != null) {
            this.list.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void drawTooltips(class_332 guiGraphics, int mouseX, int mouseY, int width, int height, float partialTick, boolean overlayActive) {
        AbilityDescription description;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, -200.0f);
        guiGraphics.method_25294(0, 0, 234, 169, class_3532.method_15375((float)(this.fade * 255.0f)) << 24);
        guiGraphics.method_51448().method_22909();
        if (this.hovered != null && !overlayActive && (description = this.hovered.getProperty(Ability.DESCRIPTION)) != null) {
            guiGraphics.method_51447(this.minecraft.field_1772, this.minecraft.field_1772.method_1728((class_5348)description.get(this.hovered.isUnlocked()), 150), mouseX, mouseY);
        }
        if (!overlayActive) {
            this.fade = class_3532.method_15363((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
        }
    }

    @Nullable
    public static ListPowerTab create(class_310 minecraft, PowersScreen screen, int tabIndex, IPowerHolder powerHolder) {
        PowerTabType[] tabTypes;
        for (PowerTabType tabType : tabTypes = PowerTabType.values()) {
            if (tabIndex < tabType.getMax()) {
                return new ListPowerTab(minecraft, screen, tabType, tabIndex, powerHolder);
            }
            tabIndex -= tabType.getMax();
        }
        return null;
    }

    public static class AbilityList
    extends class_350<ListEntry> {
        private final ListPowerTab parent;
        private final int listWidth;

        public AbilityList(class_310 minecraft, ListPowerTab screen, int width, int height, int x, int y, int itemHeight) {
            super(minecraft, width, height, y, y + height, itemHeight);
            this.method_25333(x);
            this.populate(screen.powerHolder);
            this.method_31322(false);
            this.method_31323(false);
            this.method_29344(false);
            this.parent = screen;
            this.listWidth = width;
        }

        public void populate(IPowerHolder powerHolder) {
            this.method_25339();
            for (AbilityInstance ability : powerHolder.getAbilities().values()) {
                if (ability.getProperty(Ability.HIDDEN_IN_GUI).booleanValue()) continue;
                this.method_25321(new ListEntry(ability, this, this.field_22740));
            }
        }

        public int method_25322() {
            return this.listWidth;
        }

        protected int method_25329() {
            return this.field_19088 + this.listWidth - 9;
        }

        public void method_37020(class_6382 narrationElementOutput) {
        }
    }

    public static class ListEntry
    extends class_350.class_351<ListEntry> {
        private final AbilityInstance abilityInstance;
        private final AbilityList list;
        private final class_310 minecraft;

        public ListEntry(AbilityInstance abilityInstance, AbilityList list, class_310 minecraft) {
            this.abilityInstance = abilityInstance;
            this.list = list;
            this.minecraft = minecraft;
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            guiGraphics.method_51448().method_22903();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.method_25302(PowersScreen.WIDGETS, left, top, 0, 130 + (this.abilityInstance.isUnlocked() ? (hovering ? 2 : 0) : 1) * 26, width, height);
            if (this.abilityInstance.isUnlocked()) {
                this.abilityInstance.getProperty(Ability.ICON).draw(this.minecraft, guiGraphics, DataContext.forAbility((class_1309)this.minecraft.field_1724, this.abilityInstance), left + 5, top + 5);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.method_25302(PowersScreen.WIDGETS, left + 5, top + 5, 90, 83, 16, 16);
                if (this.abilityInstance.getConfiguration().isBuyable()) {
                    guiGraphics.method_25302(PowersScreen.WIDGETS, left + 14, top + 16, 106, 83, 7, 7);
                }
            }
            guiGraphics.method_51430(this.minecraft.field_1772, class_2477.method_10517().method_30934(this.minecraft.field_1772.method_1714((class_5348)this.abilityInstance.getConfiguration().getDisplayName(), 180)), left + 30, top + 9, this.abilityInstance.isUnlocked() ? (hovering ? 16579710 : 6774089) : 3354149, false);
            guiGraphics.method_51448().method_22909();
            if (hovering) {
                this.list.parent.hovered = this.abilityInstance;
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.abilityInstance.getConfiguration().isBuyable()) {
                new RequestAbilityBuyScreenMessage(this.abilityInstance.getReference()).send();
            }
            return true;
        }
    }
}

