/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2300;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.SuperpowerUtil;
import net.threetag.palladium.util.property.PalladiumProperties;
import net.threetag.palladiumcore.util.Platform;

public class SuperpowerCommand {
    private static final SuggestionProvider<class_2168> SUGGEST_POWERS = (context, builder) -> {
        Collection<Power> powers = PowerManager.getInstance((class_1937)Objects.requireNonNull(Platform.getCurrentServer()).method_30002()).getPowers();
        return class_2172.method_9257(powers.stream().map(Power::getId), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<class_2168> SUGGEST_OWN_POWERS_ALL = (context, builder) -> {
        Collection<Object> entities;
        ArrayList superpowers = Lists.newArrayList();
        try {
            context.getArgument("entities", class_2300.class);
            entities = class_2186.method_9317((CommandContext)context, (String)"entities");
        }
        catch (Exception e) {
            entities = Collections.singleton(((class_2168)context.getSource()).method_9207());
        }
        for (class_1297 class_12972 : entities) {
            for (class_2960 id : PalladiumProperties.SUPERPOWER_IDS.get(class_12972)) {
                class_2960 allId = new class_2960(id.method_12836(), "all");
                if (!superpowers.contains(allId)) {
                    superpowers.add(allId);
                }
                if (superpowers.contains(id)) continue;
                superpowers.add(id);
            }
        }
        return class_2172.method_9270((Iterable)superpowers, (SuggestionsBuilder)builder);
    };
    public static final DynamicCommandExceptionType POWER_NOT_FOUND = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"commands.superpower.error.powerNotFound", (Object[])new Object[]{object}));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"superpower").requires(player -> player.method_9259(2))).then(class_2170.method_9247((String)"query").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(c -> SuperpowerCommand.querySuperpowers((class_2168)c.getSource(), class_2186.method_9313((CommandContext)c, (String)"entity")))))).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_POWERS).executes(c -> SuperpowerCommand.setSuperpower((class_2168)c.getSource(), Collections.singleton(((class_2168)c.getSource()).method_9207()), SuperpowerCommand.getSuperpower((CommandContext<class_2168>)c, "power")))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(c -> SuperpowerCommand.setSuperpower((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<class_2168>)c, "power"))))))).then(class_2170.method_9247((String)"add").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_POWERS).executes(c -> SuperpowerCommand.addSuperpower((class_2168)c.getSource(), Collections.singleton(((class_2168)c.getSource()).method_9207()), SuperpowerCommand.getSuperpower((CommandContext<class_2168>)c, "power")))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(c -> SuperpowerCommand.addSuperpower((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<class_2168>)c, "power"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_OWN_POWERS_ALL).executes(c -> SuperpowerCommand.removeSuperpower((class_2168)c.getSource(), Collections.singleton(((class_2168)c.getSource()).method_9207()), class_2232.method_9443((CommandContext)c, (String)"power").toString()))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(c -> SuperpowerCommand.removeSuperpower((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"entities"), class_2232.method_9443((CommandContext)c, (String)"power").toString()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"*").executes(c -> SuperpowerCommand.removeSuperpower((class_2168)c.getSource(), Collections.singleton(((class_2168)c.getSource()).method_9207()), "all"))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(c -> SuperpowerCommand.removeSuperpower((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"entities"), "all"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").executes(c -> SuperpowerCommand.removeSuperpower((class_2168)c.getSource(), Collections.singleton(((class_2168)c.getSource()).method_9207()), "all"))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(c -> SuperpowerCommand.removeSuperpower((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"entities"), "all")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"replace").then(class_2170.method_9244((String)"replaced_power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_OWN_POWERS_ALL).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"replacing_power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_POWERS).executes(c -> SuperpowerCommand.replaceSuperpower((class_2168)c.getSource(), Collections.singleton(((class_2168)c.getSource()).method_9207()), class_2232.method_9443((CommandContext)c, (String)"replaced_power").toString(), SuperpowerCommand.getSuperpower((CommandContext<class_2168>)c, "replacing_power")))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(c -> SuperpowerCommand.replaceSuperpower((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"entities"), class_2232.method_9443((CommandContext)c, (String)"replaced_power").toString(), SuperpowerCommand.getSuperpower((CommandContext<class_2168>)c, "replacing_power"))))))).then(class_2170.method_9247((String)"*").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"replacing_power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_POWERS).executes(c -> SuperpowerCommand.replaceSuperpower((class_2168)c.getSource(), Collections.singleton(((class_2168)c.getSource()).method_9207()), "all", SuperpowerCommand.getSuperpower((CommandContext<class_2168>)c, "replacing_power")))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(c -> SuperpowerCommand.replaceSuperpower((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"entities"), "all", SuperpowerCommand.getSuperpower((CommandContext<class_2168>)c, "replacing_power"))))))).then(class_2170.method_9247((String)"all").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"replacing_power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_POWERS).executes(c -> SuperpowerCommand.replaceSuperpower((class_2168)c.getSource(), Collections.singleton(((class_2168)c.getSource()).method_9207()), "all", SuperpowerCommand.getSuperpower((CommandContext<class_2168>)c, "replacing_power")))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(c -> SuperpowerCommand.replaceSuperpower((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"entities"), "all", SuperpowerCommand.getSuperpower((CommandContext<class_2168>)c, "replacing_power"))))))));
    }

    private static int querySuperpowers(class_2168 source, class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            StringBuilder result = new StringBuilder();
            int i = 0;
            for (class_2960 id : SuperpowerUtil.getSuperpowerIds(livingEntity)) {
                result.append(id.toString()).append(", ");
                ++i;
            }
            if (i == 0) {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.superpower.error.noSuperpowers", (Object[])new Object[]{livingEntity.method_5476()}));
            } else {
                source.method_9226(() -> class_2561.method_43469((String)"commands.superpower.query.success", (Object[])new Object[]{livingEntity.method_5476(), result.substring(0, result.length() - 3)}), true);
            }
            return i;
        }
        source.method_9213((class_2561)class_2561.method_43471((String)"commands.superpower.error.noLivingEntity"));
        return 0;
    }

    public static Power getSuperpower(CommandContext<class_2168> context, String key) throws CommandSyntaxException {
        class_2960 resourceLocation = (class_2960)context.getArgument(key, class_2960.class);
        Power power = PowerManager.getInstance((class_1937)((class_2168)context.getSource()).method_9225()).getPower(resourceLocation);
        if (power == null) {
            throw POWER_NOT_FOUND.create((Object)resourceLocation);
        }
        return power;
    }

    public static int setSuperpower(class_2168 commandSource, Collection<? extends class_1297> entities, Power power) {
        Iterator<? extends class_1297> iterator = entities.iterator();
        int i = 0;
        boolean no = false;
        while (iterator.hasNext()) {
            class_1297 entity = iterator.next();
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                SuperpowerUtil.setSuperpower(livingEntity, power);
                ++i;
                continue;
            }
            commandSource.method_9213((class_2561)class_2561.method_43471((String)"commands.superpower.error.noLivingEntity"));
        }
        if (i == 1) {
            commandSource.method_9226(() -> class_2561.method_43469((String)"commands.superpower.success.entity.single", (Object[])new Object[]{((class_1297)entities.iterator().next()).method_5476(), power.getName()}), true);
        } else {
            int finalI = i;
            commandSource.method_9226(() -> class_2561.method_43469((String)"commands.superpower.success.entity.multiple", (Object[])new Object[]{finalI, power.getName()}), true);
        }
        return i;
    }

    public static int addSuperpower(class_2168 commandSource, Collection<? extends class_1297> entities, Power superpower) {
        Iterator<? extends class_1297> iterator = entities.iterator();
        int i = 0;
        boolean no = false;
        while (iterator.hasNext()) {
            class_1297 entity = iterator.next();
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (SuperpowerUtil.addSuperpower(livingEntity, superpower)) {
                    ++i;
                    continue;
                }
                if (entities.size() != 1) continue;
                no = true;
                commandSource.method_9213((class_2561)class_2561.method_43469((String)"commands.superpower.error.alreadyHasSuperpower", (Object[])new Object[]{entity.method_5476()}));
                continue;
            }
            commandSource.method_9213((class_2561)class_2561.method_43471((String)"commands.superpower.error.noLivingEntity"));
        }
        if (!no) {
            if (i == 1) {
                commandSource.method_9226(() -> class_2561.method_43469((String)"commands.superpower.success.entity.single", (Object[])new Object[]{((class_1297)entities.iterator().next()).method_5476(), superpower.getName()}), true);
            } else {
                int finalI = i;
                commandSource.method_9226(() -> class_2561.method_43469((String)"commands.superpower.success.entity.multiple", (Object[])new Object[]{finalI, superpower.getName()}), true);
            }
        }
        return i;
    }

    public static int removeSuperpower(class_2168 commandSource, Collection<? extends class_1297> entities, String filter) {
        Predicate<class_2960> predicate;
        Iterator<? extends class_1297> iterator = entities.iterator();
        int i = 0;
        boolean no = false;
        Predicate<class_2960> predicate2 = filter.equalsIgnoreCase("all") ? id -> true : (predicate = filter.endsWith(":all") ? id -> id.method_12836().equals(filter.split(":")[0]) : id -> id.equals((Object)new class_2960(filter)));
        while (iterator.hasNext()) {
            class_1297 entity = iterator.next();
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (SuperpowerUtil.removeSuperpowersByIds(livingEntity, predicate) > 0) {
                    ++i;
                    continue;
                }
                if (entities.size() != 1) continue;
                no = true;
                commandSource.method_9213((class_2561)class_2561.method_43469((String)"commands.superpower.error.doesntHaveSuperpower", (Object[])new Object[]{entity.method_5476()}));
                continue;
            }
            commandSource.method_9213((class_2561)class_2561.method_43471((String)"commands.superpower.error.noLivingEntity"));
        }
        if (!no) {
            if (i == 1) {
                commandSource.method_9226(() -> class_2561.method_43469((String)"commands.superpower.remove.success.entity.single", (Object[])new Object[]{((class_1297)entities.iterator().next()).method_5476()}), true);
            } else {
                int finalI = i;
                commandSource.method_9226(() -> class_2561.method_43469((String)"commands.superpower.remove.success.entity.multiple", (Object[])new Object[]{finalI}), true);
            }
        }
        return i;
    }

    public static int replaceSuperpower(class_2168 commandSource, Collection<? extends class_1297> entities, String replacedFilter, Power replacingPower) {
        Predicate<class_2960> predicate;
        Iterator<? extends class_1297> iterator = entities.iterator();
        int i = 0;
        boolean no = false;
        Predicate<class_2960> predicate2 = replacedFilter.equalsIgnoreCase("all") ? id -> true : (predicate = replacedFilter.endsWith(":all") ? id -> id.method_12836().equals(replacedFilter.split(":")[0]) : id -> id.equals((Object)new class_2960(replacedFilter)));
        while (iterator.hasNext()) {
            class_1297 entity = iterator.next();
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (SuperpowerUtil.removeSuperpowersByIds(livingEntity, predicate) > 0 && SuperpowerUtil.addSuperpower(livingEntity, replacingPower)) {
                    ++i;
                    continue;
                }
                if (entities.size() != 1) continue;
                no = true;
                commandSource.method_9213((class_2561)class_2561.method_43469((String)"commands.superpower.error.doesntHaveSuperpower", (Object[])new Object[]{entity.method_5476()}));
                continue;
            }
            commandSource.method_9213((class_2561)class_2561.method_43471((String)"commands.superpower.error.noLivingEntity"));
        }
        if (!no) {
            if (i == 1) {
                commandSource.method_9226(() -> class_2561.method_43469((String)"commands.superpower.replace.success.entity.single", (Object[])new Object[]{((class_1297)entities.iterator().next()).method_5476()}), true);
            } else {
                int finalI = i;
                commandSource.method_9226(() -> class_2561.method_43469((String)"commands.superpower.replace.success.entity.multiple", (Object[])new Object[]{finalI}), true);
            }
        }
        return i;
    }
}

