/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.geckolib.ability;

import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.threetag.palladium.client.renderer.renderlayer.CompoundPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.client.renderer.renderlayer.RenderLayerStates;
import net.threetag.palladium.compat.geckolib.renderlayer.GeckoLayerState;
import net.threetag.palladium.entity.PalladiumLivingEntityExtension;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.ResourceLocationProperty;
import net.threetag.palladium.util.property.StringProperty;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class RenderLayerAnimationAbility
extends Ability {
    public static final PalladiumProperty<class_2960> RENDER_LAYER = new ResourceLocationProperty("render_layer").configurable("Determines the ID of the render layer receiving the animation. Must be a gecko render layer!");
    public static final PalladiumProperty<String> CONTROLLER = new StringProperty("controller").configurable("Name of the animation controller the animation is played on. Leave it as 'main' if you didnt specify one.");
    public static final PalladiumProperty<String> ANIMATION_TRIGGER = new StringProperty("animation_trigger").configurable("Name of the animation trigger");

    public RenderLayerAnimationAbility() {
        this.withProperty(RENDER_LAYER, new class_2960("test", "example_layer"));
        this.withProperty(CONTROLLER, "main");
        this.withProperty(ANIMATION_TRIGGER, "animation_trigger_name");
    }

    @Override
    public boolean isEffect() {
        return true;
    }

    @Override
    public void firstTick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && entity.method_37908().field_9236 && entity instanceof PalladiumLivingEntityExtension) {
            PalladiumLivingEntityExtension extension = (PalladiumLivingEntityExtension)entity;
            this.playAnimation(extension, entry);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void playAnimation(PalladiumLivingEntityExtension entity, AbilityInstance entry) {
        IPackRenderLayer layer = PackRenderLayerManager.getInstance().getLayer(entry.getProperty(RENDER_LAYER));
        if (layer != null) {
            List<IPackRenderLayer> layers;
            if (layer instanceof CompoundPackRenderLayer) {
                CompoundPackRenderLayer com = (CompoundPackRenderLayer)layer;
                layers = com.layers();
            } else {
                layers = Collections.singletonList(layer);
            }
            for (IPackRenderLayer renderLayer : layers) {
                GeckoLayerState gecko;
                AnimatableManager manager;
                AnimationController controller;
                RenderLayerStates.State state = entity.palladium$getRenderLayerStates().get(renderLayer);
                if (!(state instanceof GeckoLayerState) || (controller = (AnimationController)(manager = (gecko = (GeckoLayerState)state).getAnimatableInstanceCache().getManagerForId((long)(gecko.hashCode() + ((class_1297)entity).method_5628()))).getAnimationControllers().get(entry.getProperty(CONTROLLER))) == null) continue;
                controller.forceAnimationReset();
                controller.stop();
                controller.tryTriggerAnimation(entry.getProperty(ANIMATION_TRIGGER));
            }
        }
    }
}

