/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.geckolib.renderlayer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.threetag.palladium.client.dynamictexture.DynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.client.renderer.renderlayer.RenderLayerStates;
import net.threetag.palladium.client.renderer.renderlayer.RenderTypeFunction;
import net.threetag.palladium.compat.geckolib.playeranimator.ParsedAnimationController;
import net.threetag.palladium.compat.geckolib.renderlayer.GeckoLayerState;
import net.threetag.palladium.compat.geckolib.renderlayer.GeckoRenderLayerModel;
import net.threetag.palladium.entity.PalladiumLivingEntityExtension;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.Color;

public class GeckoRenderLayer
extends AbstractPackRenderLayer {
    private final SkinTypedValue<DynamicTexture> texture;
    private final SkinTypedValue<DynamicTexture> modelLocation;
    public final class_2960 animationLocation;
    public final List<ParsedAnimationController<GeckoLayerState>> animationControllers;
    public class_2960 cachedTexture;
    public class_2960 cachedModel;
    public final RenderTypeFunction renderType;
    private final GeckoRenderLayerModel model;

    public GeckoRenderLayer(SkinTypedValue<DynamicTexture> texture, SkinTypedValue<DynamicTexture> modelLocation, class_2960 animationLocation, List<ParsedAnimationController<GeckoLayerState>> animationControllers, RenderTypeFunction renderType) {
        this.texture = texture;
        this.renderType = renderType;
        this.modelLocation = modelLocation;
        this.animationLocation = animationLocation;
        this.animationControllers = animationControllers;
        this.model = new GeckoRenderLayerModel(this);
    }

    public GeckoRenderLayerModel getModel() {
        return this.model;
    }

    @Nullable
    public GeckoLayerState getState(class_1309 entity) {
        if (entity instanceof PalladiumLivingEntityExtension) {
            GeckoLayerState state;
            PalladiumLivingEntityExtension extension = (PalladiumLivingEntityExtension)entity;
            RenderLayerStates.State state2 = extension.palladium$getRenderLayerStates().getOrCreate(this);
            return state2 instanceof GeckoLayerState ? (state = (GeckoLayerState)state2) : null;
        }
        return null;
    }

    @Override
    public RenderLayerStates.State createState() {
        return new GeckoLayerState(this);
    }

    @Override
    public void render(DataContext context, class_4587 poseStack, class_4597 bufferSource, class_583<class_1297> parentModel, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        class_1309 living = context.getLivingEntity();
        if (living != null && IPackRenderLayer.conditionsFulfilled((class_1297)living, this.conditions, this.thirdPersonConditions) && parentModel instanceof class_572) {
            class_572 parentHumanoid = (class_572)parentModel;
            this.model.setCurrentRenderingFields(this.getState(living), (class_1297)living, parentHumanoid);
            this.model.method_2805(true);
            this.cachedTexture = this.texture.get((class_1297)living).getTexture(context);
            this.cachedModel = this.modelLocation.get((class_1297)living).getTexture(context);
            this.model.method_2828(poseStack, this.renderType.createVertexConsumer(bufferSource, this.cachedTexture, false), this.renderType.getPackedLight(packedLight), class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void renderArm(DataContext context, class_1306 arm, class_1007 playerRenderer, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        class_1309 living = context.getLivingEntity();
        if (living != null && IPackRenderLayer.conditionsFulfilled((class_1297)living, this.conditions, this.firstPersonConditions)) {
            GeoBone bone;
            GeckoLayerState state = this.getState(living);
            this.model.setCurrentRenderingFields(state, (class_1297)living, (class_572)playerRenderer.method_4038());
            this.cachedTexture = this.texture.get((class_1297)living).getTexture(context);
            this.cachedModel = this.modelLocation.get((class_1297)living).getTexture(context);
            this.model.grabRelevantBones(this.model.getGeoModel().getBakedModel(this.model.getGeoModel().getModelResource((GeoAnimatable)this.model.currentState)));
            GeoBone geoBone = bone = arm == class_1306.field_6183 ? this.model.getRightArmBone() : this.model.getLeftArmBone();
            if (state != null && bone != null) {
                ((class_591)playerRenderer.method_4038()).method_2818((class_572)this.model);
                this.model.applyBaseTransformations((class_572)playerRenderer.method_4038());
                float partialTick = class_310.method_1551().method_1488();
                class_4588 buffer = state.layer.renderType.createVertexConsumer(bufferSource, this.model.getTextureLocation(state), false);
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 1.5f, 0.0f);
                poseStack.method_22905(-1.0f, -1.0f, 1.0f);
                Color renderColor = this.model.getRenderColor(state, partialTick, this.renderType.getPackedLight(packedLight));
                float red = renderColor.getRedFloat();
                float green = renderColor.getGreenFloat();
                float blue = renderColor.getBlueFloat();
                float alpha = renderColor.getAlphaFloat();
                int packedOverlay = this.model.getPackedOverlay(state, 0.0f, partialTick);
                AnimationState animationState = new AnimationState((GeoAnimatable)state, 0.0f, 0.0f, partialTick, false);
                long instanceId = this.model.getInstanceId(state);
                animationState.setData(DataTickets.TICK, (Object)state.getTick(living));
                animationState.setData(DataTickets.ENTITY, (Object)living);
                animationState.setData(DataTickets.EQUIPMENT_SLOT, (Object)class_1304.field_6174);
                this.model.getGeoModel().addAdditionalStateData((GeoAnimatable)state, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
                this.model.getGeoModel().handleAnimations((GeoAnimatable)state, instanceId, animationState);
                this.model.renderRecursively(poseStack, state, bone, null, bufferSource, buffer, false, partialTick, this.renderType.getPackedLight(packedLight), packedOverlay, red, green, blue, alpha);
                poseStack.method_22909();
            }
        }
    }

    public static GeckoRenderLayer parse(JsonObject json) {
        SkinTypedValue<DynamicTexture> modelLocation = SkinTypedValue.fromJSON(json.get("model"), DynamicTextureManager::fromJson);
        SkinTypedValue<DynamicTexture> texture = SkinTypedValue.fromJSON(json.get("texture"), DynamicTextureManager::fromJson);
        RenderTypeFunction renderType = PackRenderLayerManager.getRenderType(new class_2960(class_3518.method_15253((JsonObject)json, (String)"render_type", (String)"solid")));
        if (renderType == null) {
            throw new JsonParseException("Unknown render type '" + String.valueOf(new class_2960(class_3518.method_15253((JsonObject)json, (String)"render_type", (String)"solid"))) + "'");
        }
        GeckoRenderLayer layer = new GeckoRenderLayer(texture, modelLocation, GsonUtil.getAsResourceLocation(json, "animation_file", null), GsonUtil.fromListOrPrimitive(json.get("animation_controller"), el -> ParsedAnimationController.controllerFromJson(el.getAsJsonObject()), Collections.emptyList()), renderType);
        JsonObject bonesJson = class_3518.method_15281((JsonObject)json, (String)"bones", (JsonObject)new JsonObject());
        layer.model.headBone = class_3518.method_15253((JsonObject)bonesJson, (String)"head", (String)layer.model.headBone);
        layer.model.bodyBone = class_3518.method_15253((JsonObject)bonesJson, (String)"body", (String)layer.model.bodyBone);
        layer.model.rightArmBone = class_3518.method_15253((JsonObject)bonesJson, (String)"right_arm", (String)layer.model.rightArmBone);
        layer.model.leftArmBone = class_3518.method_15253((JsonObject)bonesJson, (String)"left_arm", (String)layer.model.leftArmBone);
        layer.model.rightLegBone = class_3518.method_15253((JsonObject)bonesJson, (String)"right_leg", (String)layer.model.rightLegBone);
        layer.model.leftLegBone = class_3518.method_15253((JsonObject)bonesJson, (String)"left_leg", (String)layer.model.leftLegBone);
        return IPackRenderLayer.parseConditions(layer, json);
    }
}

