/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.trinkets.fabric;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3414;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5151;
import net.minecraft.class_5712;
import net.minecraft.class_583;
import net.threetag.palladium.client.renderer.item.CurioTrinketRenderer;
import net.threetag.palladium.compat.curiostinkets.CurioTrinket;
import net.threetag.palladium.compat.curiostinkets.CuriosTrinketsSlotInv;
import net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil;
import net.threetag.palladium.util.PlayerSlot;

public class TrinketsUtil
extends CuriosTrinketsUtil {
    @Override
    public boolean isTrinkets() {
        return true;
    }

    @Override
    public void registerCurioTrinket(class_1792 item, final CurioTrinket curioTrinket) {
        TrinketsApi.registerTrinket((class_1792)item, (Trinket)new Trinket(){

            public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
                curioTrinket.tick(entity, stack);
            }

            public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
                curioTrinket.onEquip(stack, entity);
            }

            public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
                curioTrinket.onUnequip(stack, entity);
            }

            public boolean canEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
                return curioTrinket.canEquip(stack, entity);
            }

            public boolean canUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
                return curioTrinket.canUnequip(stack, entity);
            }

            public Multimap<class_1320, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, UUID uuid) {
                ArrayListMultimap map = ArrayListMultimap.create();
                map.putAll(super.getModifiers(stack, slot, entity, uuid));
                map.putAll(curioTrinket.getModifiers(PlayerSlot.get("trinkets:" + slot.inventory().getSlotType().getGroup() + "/" + slot.inventory().getSlotType().getName()), entity));
                return map;
            }
        });
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerRenderer(class_1792 item, CurioTrinketRenderer renderer) {
        TrinketRendererRegistry.registerRenderer((class_1792)item, (TrinketRenderer)new Renderer(renderer));
    }

    @Override
    public boolean equipItem(class_1657 user, class_1799 stack) {
        Optional optional = TrinketsApi.getTrinketComponent((class_1309)user);
        if (optional.isPresent()) {
            TrinketComponent comp = (TrinketComponent)optional.get();
            for (Map group : comp.getInventory().values()) {
                for (TrinketInventory inv : group.values()) {
                    for (int i = 0; i < inv.method_5439(); ++i) {
                        class_3414 soundEvent;
                        SlotReference ref;
                        if (!inv.method_5438(i).method_7960() || !TrinketSlot.canInsert((class_1799)stack, (SlotReference)(ref = new SlotReference(inv, i)), (class_1309)user)) continue;
                        class_1799 newStack = stack.method_7972();
                        inv.method_5447(i, newStack);
                        class_1792 class_17922 = stack.method_7909();
                        if (class_17922 instanceof class_5151) {
                            class_5151 eq = (class_5151)class_17922;
                            v0 = eq.method_31570();
                        } else {
                            v0 = soundEvent = null;
                        }
                        if (!stack.method_7960() && soundEvent != null) {
                            user.method_32876(class_5712.field_28739);
                            user.method_5783(soundEvent, 1.0f, 1.0f);
                        }
                        stack.method_7939(0);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public CuriosTrinketsSlotInv getSlot(class_1309 entity, String slotKey) {
        CuriosTrinketsSlotInv[] container = new CuriosTrinketsSlotInv[]{CuriosTrinketsSlotInv.EMPTY};
        Pair<String, String> slot = this.parseSlot(slotKey);
        TrinketsApi.getTrinketComponent((class_1309)entity).ifPresent(comp -> {
            TrinketInventory trinketSlot;
            Map group = (Map)comp.getInventory().get(slot.getFirst());
            if (group != null && (trinketSlot = (TrinketInventory)group.get(slot.getSecond())) != null) {
                container[0] = new SlotInv(trinketSlot);
            }
        });
        return container[0];
    }

    public Pair<String, String> parseSlot(String slot) {
        String[] split = slot.split("/");
        if (split.length != 2) {
            return Pair.of((Object)"", (Object)"");
        }
        return Pair.of((Object)split[0], (Object)split[1]);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Renderer
    implements TrinketRenderer {
        private final CurioTrinketRenderer renderer;

        public Renderer(CurioTrinketRenderer renderer) {
            this.renderer = renderer;
        }

        public void render(class_1799 itemStack, SlotReference slotReference, class_583<? extends class_1309> entityModel, class_4587 poseStack, class_4597 multiBufferSource, int i, class_1309 livingEntity, float v, float v1, float v2, float v3, float v4, float v5) {
            this.renderer.render(itemStack, poseStack, entityModel, livingEntity, multiBufferSource, i, v, v1, v2, v3, v4, v5);
        }
    }

    public static class SlotInv
    implements CuriosTrinketsSlotInv {
        private final TrinketInventory inventory;

        public SlotInv(TrinketInventory inventory) {
            this.inventory = inventory;
        }

        @Override
        public int getSlots() {
            return this.inventory.method_5439();
        }

        @Override
        public class_1799 getStackInSlot(int index) {
            return this.inventory.method_5438(index);
        }

        @Override
        public void setStackInSlot(int index, class_1799 stack) {
            this.inventory.method_5447(index, stack);
        }
    }
}

