/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.context.DataContextType;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;

public class CommandResultCondition
extends Condition
implements class_2165 {
    private final String command;
    private final String comparison;
    private final int compare_to;
    private final boolean log;

    public CommandResultCondition(String command, String comparison, int compare_to, boolean log) {
        this.command = command;
        this.comparison = comparison;
        this.compare_to = compare_to;
        this.log = log;
    }

    @Override
    public boolean active(DataContext context) {
        class_1297 entity = context.get(DataContextType.ENTITY);
        if (entity == null) {
            return false;
        }
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2168 stack = new class_2168((class_2165)this, entity.method_19538(), entity.method_5802(), serverLevel, 2, entity.method_5477().getString(), entity.method_5476(), entity.method_37908().method_8503(), entity).method_9217();
            if (!this.log) {
                stack = stack.method_9217();
            }
            int result = serverLevel.method_8503().method_3734().method_44252(stack, this.command);
            return switch (this.comparison) {
                case ">=" -> {
                    if (result >= this.compare_to) {
                        yield true;
                    }
                    yield false;
                }
                case "<=" -> {
                    if (result <= this.compare_to) {
                        yield true;
                    }
                    yield false;
                }
                case ">" -> {
                    if (result > this.compare_to) {
                        yield true;
                    }
                    yield false;
                }
                case "<" -> {
                    if (result < this.compare_to) {
                        yield true;
                    }
                    yield false;
                }
                case "!=" -> {
                    if (result != this.compare_to) {
                        yield true;
                    }
                    yield false;
                }
                case "==" -> {
                    if (result == this.compare_to) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    @Override
    public ConditionEnvironment getEnvironment() {
        return ConditionEnvironment.DATA;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.COMMAND_RESULT.get();
    }

    public void method_43496(class_2561 component) {
        if (this.log) {
            AddonPackLog.info("Command Result Condition Log: " + component.getString(), new Object[0]);
        }
    }

    public boolean method_9200() {
        return this.log;
    }

    public boolean method_9202() {
        return this.log;
    }

    public boolean method_9201() {
        return this.log;
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<String> COMMAND = new StringProperty("command").configurable("The command output to compare the 'compare_to' int with");
        public static final PalladiumProperty<String> COMPARISON = new StringProperty("comparison").configurable("The comparison used between the 'command' and 'compare_to' fields, accepts >=, <=, >, <, !=, or == (note that the first number is from 'command' and the second from 'compare_to')");
        public static final PalladiumProperty<Integer> COMPARE_TO = new IntegerProperty("compare_to").configurable("The number being compared to the output of 'command'");
        public static final PalladiumProperty<Boolean> LOG = new BooleanProperty("log").configurable("If the command's output is sent to the entity or not (unless debugging, you probably want this false/unset)");

        public Serializer() {
            this.withProperty(COMMAND, "execute if entity @s");
            this.withProperty(COMPARISON, "==");
            this.withProperty(COMPARE_TO, 1);
            this.withProperty(LOG, false);
        }

        @Override
        public Condition make(JsonObject json) {
            return new CommandResultCondition(this.getProperty(json, COMMAND), this.getProperty(json, COMPARISON), this.getProperty(json, COMPARE_TO), this.getProperty(json, LOG));
        }

        @Override
        public String getDocumentationDescription() {
            return "Executes a command and compares the output to a number.";
        }
    }
}

