/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.ResourceLocationProperty;

public class HasPowerCondition
extends Condition {
    public final class_2960 powerId;

    public HasPowerCondition(class_2960 powerId) {
        this.powerId = powerId;
    }

    @Override
    public boolean active(DataContext context) {
        class_1309 entity = context.getLivingEntity();
        if (entity == null) {
            return false;
        }
        IPowerHandler handler = PowerManager.getPowerHandler(entity).orElse(null);
        return handler != null && handler.getPowerHolders().containsKey(this.powerId);
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.HAS_POWER.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<class_2960> POWER = new ResourceLocationProperty("power").configurable("ID of the power that is required");

        public Serializer() {
            this.withProperty(POWER, new class_2960("example:power_id"));
        }

        @Override
        public Condition make(JsonObject json) {
            return new HasPowerCondition(this.getProperty(json, POWER));
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the entity has a power with the given ID.";
        }
    }
}

