/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.class_1309;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class HealthCondition
extends Condition {
    private final float minHealth;
    private final float maxHealth;

    public HealthCondition(float minHealth, float maxHealth) {
        this.minHealth = minHealth;
        this.maxHealth = maxHealth;
    }

    @Override
    public boolean active(DataContext context) {
        class_1309 entity = context.getLivingEntity();
        if (entity == null) {
            return false;
        }
        return entity.method_6032() >= this.minHealth && entity.method_6032() <= this.maxHealth;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.HEALTH.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<Float> MIN_HEALTH = new FloatProperty("min_health").configurable("Minimum required amount of health");
        public static final PalladiumProperty<Float> MAX_HEALTH = new FloatProperty("max_health").configurable("Maximum required amount of health");

        public Serializer() {
            this.withProperty(MIN_HEALTH, Float.valueOf(0.0f));
            this.withProperty(MAX_HEALTH, Float.valueOf(Float.MAX_VALUE));
        }

        @Override
        public Condition make(JsonObject json) {
            return new HealthCondition(this.getProperty(json, MIN_HEALTH).floatValue(), this.getProperty(json, MAX_HEALTH).floatValue());
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the entity has a certain amount of health.";
        }
    }
}

