/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.item.Openable;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PlayerSlotProperty;

public class ItemInSlotOpenCondition
extends Condition {
    private final PlayerSlot slot;

    public ItemInSlotOpenCondition(PlayerSlot slot) {
        this.slot = slot;
    }

    @Override
    public boolean active(DataContext context) {
        class_1309 entity = context.getLivingEntity();
        if (entity == null) {
            return false;
        }
        List<class_1799> stacks = this.slot.getItems(entity);
        for (class_1799 stack : stacks) {
            Openable openable;
            class_1792 class_17922;
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof Openable) || !(openable = (Openable)class_17922).isOpen(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.ITEM_IN_SLOT_OPEN.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<PlayerSlot> SLOT = new PlayerSlotProperty("slot").configurable("Slot that must contain an opened item");

        public Serializer() {
            this.withProperty(SLOT, PlayerSlot.get(class_1304.field_6174.method_5923()));
        }

        @Override
        public Condition make(JsonObject json) {
            return new ItemInSlotOpenCondition(this.getProperty(json, SLOT));
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the item in the given slot is opened. Needs to be using the openable-system for items.";
        }
    }
}

