/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.threetag.palladium.condition.BuyableCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.ComponentProperty;
import net.threetag.palladium.util.property.IconProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;

public class ScoreboardScoreBuyableCondition
extends BuyableCondition {
    private final String objective;
    private final int amount;
    private final IIcon icon;
    private final class_2561 description;

    public ScoreboardScoreBuyableCondition(String objective, int amount, IIcon icon, class_2561 description) {
        this.objective = objective;
        this.amount = amount;
        this.icon = icon;
        this.description = description;
    }

    @Override
    public AbilityConfiguration.UnlockData createData() {
        return new AbilityConfiguration.UnlockData(this.icon, this.amount, this.description);
    }

    @Override
    public boolean isAvailable(class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_266 objective = player.method_7327().method_1170(this.objective);
            return objective != null && player.method_7327().method_1180(player.method_5820(), objective).method_1126() >= this.amount;
        }
        return false;
    }

    @Override
    public boolean takeFromEntity(class_1309 entity) {
        class_267 score;
        class_1657 player;
        class_266 objective;
        if (entity instanceof class_1657 && (objective = (player = (class_1657)entity).method_7327().method_1170(this.objective)) != null && (score = player.method_7327().method_1180(player.method_5820(), objective)).method_1126() >= this.amount) {
            score.method_1128(score.method_1126() - this.amount);
            return true;
        }
        return false;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.SCOREBOARD_SCORE_BUYABLE.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<String> OBJECTIVE = new StringProperty("objective").configurable("Name of the scoreboard objective");
        public static final PalladiumProperty<Integer> SCORE = new IntegerProperty("score").configurable("Required player score for the scoreboard objective");
        public static final PalladiumProperty<IIcon> ICON = new IconProperty("icon").configurable("Icon that will be displayed during buying");
        public static final PalladiumProperty<class_2561> DESCRIPTION = new ComponentProperty("description").configurable("Name of the score that will be displayed during buying");

        public Serializer() {
            this.withProperty(OBJECTIVE, "objective_name");
            this.withProperty(SCORE, 3);
            this.withProperty(ICON, new ItemIcon((class_1935)class_1802.field_8866));
            this.withProperty(DESCRIPTION, class_2561.method_43470((String)"Scoreboard Score"));
        }

        @Override
        public ConditionEnvironment getContextEnvironment() {
            return ConditionEnvironment.DATA;
        }

        @Override
        public Condition make(JsonObject json) {
            return new ScoreboardScoreBuyableCondition(this.getProperty(json, OBJECTIVE), this.getProperty(json, SCORE), this.getProperty(json, ICON), this.getProperty(json, DESCRIPTION));
        }

        @Override
        public String getDocumentationDescription() {
            return "A buyable condition that requires a certain score for a scoreboard objective.";
        }
    }
}

