/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.util.PlayerUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladiumcore.util.Platform;

public class SmallArmsCondition
extends Condition {
    @Override
    public boolean active(DataContext context) {
        if (Platform.isClient()) {
            return this.has(context.getPlayer());
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private boolean has(class_1657 player) {
        return PlayerUtil.hasSmallArms(player);
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.SMALL_ARMS.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        @Override
        public Condition make(JsonObject json) {
            return new SmallArmsCondition();
        }

        @Override
        public ConditionEnvironment getContextEnvironment() {
            return ConditionEnvironment.ASSETS;
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the entity has small arms. Returns false if the entity is not a player or if this condition is being checked sever-side.";
        }
    }
}

