/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.energy;

import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.threetag.palladium.energy.IEnergyStorage;

public class EnergyStorage
implements IEnergyStorage {
    protected int energy;
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public EnergyStorage(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public EnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public EnergyStorage(int capacity, int maxReceive, int maxExtract) {
        this(capacity, maxReceive, maxExtract, 0);
    }

    public EnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = Math.max(0, Math.min(capacity, energy));
    }

    @Override
    public boolean canInsert() {
        return this.maxReceive > 0;
    }

    @Override
    public int insertEnergy(int maxAmount, boolean simulate) {
        if (!this.canInsert()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, this.maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public boolean canWithdraw() {
        return this.maxExtract > 0;
    }

    @Override
    public int withdrawEnergy(int maxAmount, boolean simulate) {
        if (!this.canWithdraw()) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, this.maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyAmount() {
        return this.energy;
    }

    @Override
    public int getEnergyCapacity() {
        return this.capacity;
    }

    public void modifyEnergy(int energy) {
        this.energy = class_3532.method_15340((int)(this.energy + energy), (int)0, (int)this.getEnergyCapacity());
    }

    public class_2520 serializeNBT() {
        return class_2497.method_23247((int)this.getEnergyAmount());
    }

    public void deserializeNBT(class_2520 nbt) {
        if (!(nbt instanceof class_2497)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        class_2497 intNbt = (class_2497)nbt;
        this.energy = intNbt.method_10701();
    }
}

