/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2664;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.threetag.palladium.util.SizeUtil;
import net.threetag.palladiumcore.network.ExtendedEntitySpawnData;
import net.threetag.palladiumcore.network.NetworkManager;
import org.jetbrains.annotations.Nullable;

public class CustomProjectile
extends class_1682
implements ExtendedEntitySpawnData {
    public static final Map<String, Function<class_2487, Appearance>> APPEARANCE_REGISTRY = new HashMap<String, Function<class_2487, Appearance>>();
    public static Consumer<CustomProjectile> KUBEJS_EVENT_HANDLER = null;
    public class_2960 damageType;
    public float damage = 3.0f;
    public float gravity = 0.03f;
    public boolean dieOnBlockHit = true;
    public boolean dieOnEntityHit = true;
    public boolean preventShooterInteraction = false;
    public int lifetime = -1;
    public int setEntityOnFireSeconds = 0;
    public float explosionRadius = 0.0f;
    public boolean explosionCausesFire = false;
    public class_1927.class_4179 explosionBlockInteraction = class_1927.class_4179.field_40878;
    public float knockbackStrength = 0.0f;
    public String commandOnEntityHit = null;
    public String commandOnBlockHit = null;
    public class_4048 dimensions = new class_4048(0.1f, 0.1f, false);
    public List<Appearance> appearances = new ArrayList<Appearance>();

    public CustomProjectile(class_1299<? extends class_1682> entityType, class_1937 level) {
        super(entityType, level);
    }

    public class_2596<class_2602> method_18002() {
        return NetworkManager.createAddEntityPacket((class_1297)this);
    }

    public boolean method_5640(double distance) {
        return true;
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.dimensions.method_19539(SizeUtil.getInstance().getWidthScale((class_1297)this), SizeUtil.getInstance().getHeightScale((class_1297)this));
    }

    protected void method_5693() {
    }

    protected float method_7490() {
        return this.gravity;
    }

    public boolean method_34714(class_1297 entity) {
        return super.method_34714(entity);
    }

    protected void method_7454(class_3966 result) {
        class_1297 entity;
        if (!(this.method_37908().field_9236 || (entity = result.method_17782()) == this.method_24921() && this.preventShooterInteraction)) {
            if (this.commandOnEntityHit != null && !this.commandOnEntityHit.isBlank()) {
                this.method_37908().method_8503().method_3734().method_44252(this.method_5671().method_9230(2).method_9217(), this.commandOnEntityHit);
            }
            if (this.damage > 0.0f) {
                class_1282 damageType = entity.method_37908().method_48963().method_48811(this.method_24921(), (class_1297)this);
                if (this.damageType != null) {
                    damageType = this.method_48923().method_48797(class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)this.damageType), this.method_24921(), (class_1297)this);
                }
                entity.method_5643(damageType, this.damage);
            }
            if (this.setEntityOnFireSeconds > 0) {
                entity.method_5639(this.setEntityOnFireSeconds);
            }
            if (this.explosionRadius > 0.0f) {
                this.explode((class_1297)this, this.method_37908().method_48963().method_48811((class_1297)this, this.method_24921()), this.method_23317(), this.method_23320(), this.method_23321(), this.explosionRadius, this.explosionCausesFire, this.explosionBlockInteraction);
            }
            if (this.knockbackStrength > 0.0f && entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                living.method_6005((double)this.knockbackStrength, -this.method_18798().field_1352, -this.method_18798().field_1350);
            }
            if (this.dieOnEntityHit) {
                this.method_37908().method_8421((class_1297)this, (byte)3);
                this.method_31472();
            }
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (!this.method_37908().field_9236) {
            if (this.commandOnBlockHit != null && !this.commandOnBlockHit.isBlank()) {
                this.method_37908().method_8503().method_3734().method_44252(this.method_5671().method_9230(2).method_9217(), this.commandOnBlockHit);
            }
            if (this.explosionRadius > 0.0f) {
                this.explode((class_1297)this, this.method_37908().method_48963().method_48811((class_1297)this, this.method_24921()), this.method_23317(), this.method_23320(), this.method_23321(), this.explosionRadius, this.explosionCausesFire, this.explosionBlockInteraction);
            }
            if (this.dieOnBlockHit) {
                this.method_37908().method_8421((class_1297)this, (byte)3);
                this.method_31472();
            }
        }
    }

    public class_1927 explode(class_1297 source, @Nullable class_1282 damageSource, double x, double y, double z, float radius, boolean fire, class_1927.class_4179 blockInteraction) {
        class_1927 explosion = new class_1927(source.method_37908(), source, damageSource, null, x, y, z, radius, fire, blockInteraction);
        explosion.method_8348();
        explosion.method_8350(true);
        if (!explosion.method_46667()) {
            explosion.method_8352();
        }
        for (class_1657 player : source.method_37908().method_18456()) {
            if (!(player.method_5649(x, y, z) < 4096.0) || !(player instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.field_13987.method_14364((class_2596)new class_2664(x, y, z, radius, explosion.method_8346(), (class_243)explosion.method_8351().get(serverPlayer)));
        }
        return explosion;
    }

    public void method_5711(byte state) {
        if (state == 3) {
            for (Appearance appearance : this.appearances) {
                appearance.spawnParticlesOnHit(this);
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        for (Appearance appearance : this.appearances) {
            appearance.onTick(this);
        }
        if (KUBEJS_EVENT_HANDLER != null) {
            KUBEJS_EVENT_HANDLER.accept(this);
        }
        if (this.lifetime > 0 && this.field_6012 >= this.lifetime && !this.method_37908().field_9236) {
            this.method_31472();
        }
    }

    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.damageType != null) {
            compound.method_10582("DamageType", this.damageType.toString());
        }
        compound.method_10548("Damage", this.damage);
        compound.method_10548("Gravity", this.gravity);
        compound.method_10556("DieOnEntityHit", this.dieOnEntityHit);
        compound.method_10556("DieOnBlockHit", this.dieOnBlockHit);
        compound.method_10556("PreventShooterInteraction", this.preventShooterInteraction);
        compound.method_10548("Size", this.dimensions.field_18067);
        compound.method_10548("Lifetime", (float)this.lifetime);
        compound.method_10548("SetEntityOnFireSeconds", (float)this.setEntityOnFireSeconds);
        compound.method_10548("ExplosionRadius", this.explosionRadius);
        compound.method_10556("ExplosionCausesFire", this.explosionCausesFire);
        compound.method_10582("ExplosionBlockInteraction", this.explosionBlockInteraction.toString().toLowerCase(Locale.ROOT));
        compound.method_10548("KnockbackStrength", this.knockbackStrength);
        if (this.commandOnEntityHit != null) {
            compound.method_10582("CommandOnEntityHit", this.commandOnEntityHit);
        }
        if (this.commandOnBlockHit != null) {
            compound.method_10582("CommandOnBlockHit", this.commandOnBlockHit);
        }
        class_2499 appearanceList = new class_2499();
        for (Appearance appearance : this.appearances) {
            class_2487 aTag = new class_2487();
            aTag.method_10582("Type", appearance.getId());
            appearance.toNBT(aTag);
            appearanceList.add((Object)aTag);
        }
        compound.method_10566("Appearances", (class_2520)appearanceList);
    }

    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573("DamageType", 8)) {
            this.damageType = new class_2960(compound.method_10558("DamageType"));
        }
        if (compound.method_10573("Damage", 99)) {
            this.damage = compound.method_10583("Damage");
        }
        if (compound.method_10573("Gravity", 99)) {
            this.gravity = compound.method_10583("Gravity");
        }
        if (compound.method_10573("Lifetime", 99)) {
            this.lifetime = compound.method_10550("Lifetime");
        }
        if (compound.method_10573("SetEntityOnFireSeconds", 99)) {
            this.setEntityOnFireSeconds = compound.method_10550("SetEntityOnFireSeconds");
        }
        if (compound.method_10545("DieOnEntityHit")) {
            this.dieOnEntityHit = compound.method_10577("DieOnEntityHit");
        }
        if (compound.method_10545("DieOnBlockHit")) {
            this.dieOnBlockHit = compound.method_10577("DieOnBlockHit");
        }
        if (compound.method_10545("PreventShooterInteraction")) {
            this.preventShooterInteraction = compound.method_10577("PreventShooterInteraction");
        }
        if (compound.method_10573("Size", 99)) {
            this.dimensions = new class_4048(compound.method_10583("Size"), compound.method_10583("Size"), false);
        }
        if (compound.method_10573("ExplosionRadius", 99)) {
            this.explosionRadius = compound.method_10583("ExplosionRadius");
        }
        if (compound.method_10545("ExplosionCausesFire")) {
            this.explosionCausesFire = compound.method_10577("ExplosionCausesFire");
        }
        if (compound.method_10545("ExplosionBlockInteraction")) {
            String type = compound.method_10558("ExplosionBlockInteraction");
            class_1927.class_4179 class_41792 = type.equalsIgnoreCase("break") ? class_1927.class_4179.field_18687 : (this.explosionBlockInteraction = type.equalsIgnoreCase("destroy") ? class_1927.class_4179.field_40879 : class_1927.class_4179.field_40878);
        }
        if (compound.method_10573("KnockbackStrength", 99)) {
            this.knockbackStrength = compound.method_10583("KnockbackStrength");
        }
        if (compound.method_10545("CommandOnEntityHit")) {
            this.commandOnEntityHit = compound.method_10558("CommandOnEntityHit");
        }
        if (compound.method_10545("CommandOnBlockHit")) {
            this.commandOnBlockHit = compound.method_10558("CommandOnBlockHit");
        }
        if (compound.method_10545("Appearances")) {
            this.appearances = new ArrayList<Appearance>();
            class_2499 listTag = compound.method_10554("Appearances", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 aTag = listTag.method_10602(i);
                Function<class_2487, Appearance> type = APPEARANCE_REGISTRY.get(aTag.method_10558("Type"));
                if (type == null) continue;
                this.appearances.add(type.apply(aTag));
            }
        }
        this.method_18382();
    }

    public void saveAdditionalSpawnData(class_2540 buf) {
        class_2487 tag = new class_2487();
        this.method_5652(tag);
        buf.method_10794(tag);
        buf.writeFloat(this.method_36455());
        buf.writeFloat(this.method_36454());
    }

    public void loadAdditionalSpawnData(class_2540 buf) {
        this.method_5749(Objects.requireNonNull(buf.method_10798()));
        this.method_36457(buf.readFloat());
        this.method_36456(buf.readFloat());
    }

    static {
        APPEARANCE_REGISTRY.put("item", ItemAppearance::new);
        APPEARANCE_REGISTRY.put("particles", ParticleAppearance::new);
        APPEARANCE_REGISTRY.put("laser", LaserAppearance::new);
        APPEARANCE_REGISTRY.put("renderLayer", RenderLayerAppearance::new);
        APPEARANCE_REGISTRY.put("trail", TrailAppearance::new);
    }

    public static abstract class Appearance {
        public Appearance(class_2487 tag) {
        }

        public abstract String getId();

        public void onTick(CustomProjectile projectile) {
        }

        public void spawnParticlesOnHit(CustomProjectile projectile) {
        }

        public abstract void toNBT(class_2487 var1);
    }

    public static class TrailAppearance
    extends Appearance {
        public final List<class_2960> trails = new ArrayList<class_2960>();

        public TrailAppearance(class_2487 tag) {
            super(tag);
            class_2520 trailTag = tag.method_10580("Trail");
            if (trailTag instanceof class_2519) {
                class_2519 stringTag = (class_2519)trailTag;
                this.trails.add(new class_2960(stringTag.method_10714()));
            } else if (trailTag instanceof class_2499) {
                class_2499 list = (class_2499)trailTag;
                for (class_2520 t : list) {
                    if (!(t instanceof class_2519)) continue;
                    class_2519 stringTag = (class_2519)t;
                    this.trails.add(new class_2960(stringTag.method_10714()));
                }
            }
        }

        @Override
        public String getId() {
            return "trail";
        }

        @Override
        public void toNBT(class_2487 nbt) {
            if (this.trails.size() == 1) {
                nbt.method_10582("Trail", this.trails.get(0).toString());
            } else {
                class_2499 listTag = new class_2499();
                for (class_2960 layer : this.trails) {
                    listTag.add((Object)class_2519.method_23256((String)layer.toString()));
                }
                nbt.method_10566("Trail", (class_2520)listTag);
            }
        }
    }

    public static class RenderLayerAppearance
    extends Appearance {
        public final List<class_2960> renderLayers = new ArrayList<class_2960>();

        public RenderLayerAppearance(class_2487 tag) {
            super(tag);
            class_2520 layerTag = tag.method_10580("RenderLayer");
            if (layerTag instanceof class_2519) {
                class_2519 stringTag = (class_2519)layerTag;
                this.renderLayers.add(new class_2960(stringTag.method_10714()));
            } else if (layerTag instanceof class_2499) {
                class_2499 list = (class_2499)layerTag;
                for (class_2520 t : list) {
                    if (!(t instanceof class_2519)) continue;
                    class_2519 stringTag = (class_2519)t;
                    this.renderLayers.add(new class_2960(stringTag.method_10714()));
                }
            }
        }

        @Override
        public String getId() {
            return "renderLayer";
        }

        @Override
        public void toNBT(class_2487 nbt) {
            if (this.renderLayers.size() == 1) {
                nbt.method_10582("RenderLayer", this.renderLayers.get(0).toString());
            } else {
                class_2499 listTag = new class_2499();
                for (class_2960 layer : this.renderLayers) {
                    listTag.add((Object)class_2519.method_23256((String)layer.toString()));
                }
                nbt.method_10566("RenderLayer", (class_2520)listTag);
            }
        }
    }

    public static class LaserAppearance
    extends Appearance {
        public final float thickness;
        public final Color color;

        public LaserAppearance(class_2487 tag) {
            super(tag);
            this.thickness = tag.method_10545("Thickness") ? tag.method_10583("Thickness") : 0.05f;
            class_2520 colorTag = tag.method_10580("Color");
            if (colorTag instanceof class_2519) {
                class_2519 stringTag = (class_2519)colorTag;
                this.color = Color.decode(stringTag.method_10714());
            } else if (colorTag instanceof class_2487) {
                class_2487 compoundTag = (class_2487)colorTag;
                this.color = new Color(compoundTag.method_10550("Red"), compoundTag.method_10550("Green"), compoundTag.method_10550("Blue"));
            } else {
                this.color = Color.RED;
            }
        }

        @Override
        public String getId() {
            return "laser";
        }

        @Override
        public void toNBT(class_2487 nbt) {
            nbt.method_10548("Thickness", this.thickness);
            class_2487 colorTag = new class_2487();
            colorTag.method_10569("Red", this.color.getRed());
            colorTag.method_10569("Green", this.color.getGreen());
            colorTag.method_10569("Blue", this.color.getBlue());
            nbt.method_10566("Color", (class_2520)colorTag);
        }
    }

    public static class ItemAppearance
    extends Appearance {
        public final class_1799 item;

        public ItemAppearance(class_2487 tag) {
            super(tag);
            class_2520 itemTag = tag.method_10580("Item");
            if (itemTag instanceof class_2487) {
                class_2487 compoundTag = (class_2487)itemTag;
                this.item = class_1799.method_7915((class_2487)compoundTag);
            } else if (itemTag instanceof class_2519) {
                class_2519 stringTag = (class_2519)itemTag;
                this.item = new class_1799((class_1935)class_7923.field_41178.method_10223(new class_2960(stringTag.method_10714())));
            } else {
                this.item = class_1799.field_8037;
            }
        }

        @Override
        public String getId() {
            return "item";
        }

        @Override
        public void toNBT(class_2487 nbt) {
            nbt.method_10566("Item", (class_2520)this.item.method_7953(new class_2487()));
        }

        @Override
        public void spawnParticlesOnHit(CustomProjectile projectile) {
            class_2392 data = new class_2392(class_2398.field_11218, this.item);
            for (int i = 0; i < 8; ++i) {
                projectile.method_37908().method_8406((class_2394)data, projectile.method_23317(), projectile.method_23318(), projectile.method_23321(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static class ParticleAppearance
    extends Appearance {
        public final class_2396 type;
        public final int amount;
        public final float spread;
        public final String options;

        public ParticleAppearance(class_2487 tag) {
            super(tag);
            this.type = tag.method_10545("ParticleType") ? (class_2396)class_7923.field_41180.method_10223(new class_2960(tag.method_10558("ParticleType"))) : class_2398.field_11240;
            this.amount = tag.method_10545("Amount") ? tag.method_10550("Amount") : 1;
            this.spread = tag.method_10545("Spread") ? tag.method_10583("Spread") : 1.0f;
            this.options = tag.method_10545("Options") ? tag.method_10558("Options") : "";
        }

        @Override
        public String getId() {
            return "particles";
        }

        @Override
        public void toNBT(class_2487 nbt) {
            if (this.type != null) {
                nbt.method_10582("ParticleType", class_7923.field_41180.method_10221((Object)this.type).toString());
            }
            nbt.method_10569("Amount", this.amount);
            nbt.method_10548("Spread", this.spread);
            nbt.method_10582("Options", this.options);
        }

        @Override
        public void onTick(CustomProjectile projectile) {
            if (this.type == null) {
                return;
            }
            Random random = new Random();
            for (int i = 0; i < this.amount; ++i) {
                float sX = (random.nextFloat() - 0.5f) * this.spread * SizeUtil.getInstance().getWidthScale((class_1297)projectile);
                float sY = (random.nextFloat() - 0.5f) * this.spread * SizeUtil.getInstance().getHeightScale((class_1297)projectile);
                float sZ = (random.nextFloat() - 0.5f) * this.spread * SizeUtil.getInstance().getWidthScale((class_1297)projectile);
                try {
                    projectile.method_37908().method_8406(this.type.method_10298().method_10296(this.type, new StringReader(this.options)), projectile.method_23317(), projectile.method_23318(), projectile.method_23321(), (double)sX, (double)sY, (double)sZ);
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void spawnParticlesOnHit(CustomProjectile projectile) {
            if (this.type == null) {
                return;
            }
            for (int i = 0; i < this.amount; ++i) {
                Random random = new Random();
                float sX = (random.nextFloat() - 0.5f) * this.spread * 2.0f;
                float sY = (random.nextFloat() - 0.5f) * this.spread * 2.0f;
                float sZ = (random.nextFloat() - 0.5f) * this.spread * 2.0f;
                try {
                    projectile.method_37908().method_8406(this.type.method_10298().method_10296(this.type, new StringReader(this.options)), projectile.method_23317(), projectile.method_23318(), projectile.method_23321(), (double)sX, (double)sY, (double)sZ);
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
    }
}

