/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity.effect;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.threetag.palladium.client.energybeam.EnergyBeamConfiguration;
import net.threetag.palladium.client.energybeam.EnergyBeamManager;
import net.threetag.palladium.entity.EffectEntity;
import net.threetag.palladium.entity.effect.EntityEffect;
import net.threetag.palladium.entity.effect.EntityEffects;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladium.power.ability.AnimationTimer;
import net.threetag.palladium.power.ability.EnergyBeamAbility;
import net.threetag.palladium.util.property.AbilityReferenceProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;

public class EnergyBeamEffect
extends EntityEffect {
    public static final PalladiumProperty<AbilityReference> ABILITY = new AbilityReferenceProperty("ability");

    @Override
    public void registerProperties(PropertyManager manager) {
        super.registerProperties(manager);
        manager.register(ABILITY, null);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(EffectEntity entity, class_1297 anchor, class_4587 poseStack, class_4597 bufferSource, int packedLightIn, boolean isFirstPerson, float partialTicks) {
        if (anchor instanceof class_742) {
            class_742 player = (class_742)anchor;
            AbilityInstance instance = this.get(entity, ABILITY).getEntry((class_1309)player);
            if (instance != null) {
                EnergyBeamAbility.updateTargetPos((class_1309)player, instance, partialTicks);
                EnergyBeamConfiguration beam = EnergyBeamManager.INSTANCE.get(instance.getProperty(EnergyBeamAbility.BEAM));
                if (beam != null) {
                    class_243 entityPos = entity.method_30950(partialTicks);
                    class_243 target = instance.getProperty(EnergyBeamAbility.TARGET);
                    beam.render(player, entityPos, target, this.getLengthMultiplier(instance, partialTicks), poseStack, bufferSource, packedLightIn, isFirstPerson, partialTicks);
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public float getLengthMultiplier(AbilityInstance instance, float partialTick) {
        Ability ability = instance.getConfiguration().getAbility();
        if (ability instanceof AnimationTimer) {
            AnimationTimer animationTimer = (AnimationTimer)((Object)ability);
            return animationTimer.getAnimationTimer(instance, partialTick, instance.getProperty(EnergyBeamAbility.SPEED).floatValue() <= 0.0f);
        }
        return 1.0f;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tick(EffectEntity entity, class_1297 anchor) {
        if (anchor instanceof class_742) {
            class_742 player = (class_742)anchor;
            AbilityInstance instance = this.get(entity, ABILITY).getEntry((class_1309)player);
            if (instance != null) {
                boolean isDonePlaying;
                EnergyBeamConfiguration beam = EnergyBeamManager.INSTANCE.get(instance.getProperty(EnergyBeamAbility.BEAM));
                if (beam == null) {
                    this.stopPlaying(entity);
                    return;
                }
                boolean bl = instance.getProperty(EnergyBeamAbility.SPEED).floatValue() <= 0.0f ? !instance.isEnabled() : (isDonePlaying = this.getLengthMultiplier(instance, 0.0f) <= 0.0f && !instance.isEnabled());
                if (isDonePlaying != (Boolean)this.get(entity, IS_DONE_PLAYING)) {
                    this.stopPlaying(entity);
                }
            } else {
                this.stopPlaying(entity);
            }
        } else {
            this.stopPlaying(entity);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void start(class_1657 player, AbilityReference abilityReference) {
        EffectEntity effectEntity = new EffectEntity(player.method_37908(), (class_1297)player, (EntityEffect)EntityEffects.ENERGY_BEAM.get());
        ABILITY.set(effectEntity, abilityReference);
        Objects.requireNonNull(class_310.method_1551().field_1687).method_2942(0, (class_1297)effectEntity);
    }
}

