/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity.effect;

import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.entity.EffectEntity;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;
import net.threetag.palladiumcore.registry.PalladiumRegistry;

public abstract class EntityEffect {
    public static final PalladiumRegistry<EntityEffect> REGISTRY = PalladiumRegistry.create(EntityEffect.class, (class_2960)Palladium.id("entity_effects"));
    public static final PalladiumProperty<Boolean> IS_DONE_PLAYING = new BooleanProperty("is_done_playing");

    public void registerProperties(PropertyManager manager) {
        manager.register(IS_DONE_PLAYING, false);
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void render(EffectEntity var1, class_1297 var2, class_4587 var3, class_4597 var4, int var5, boolean var6, float var7);

    public abstract void tick(EffectEntity var1, class_1297 var2);

    public boolean isInRangeToRenderDist(EffectEntity effectEntity, class_1297 anchor, double distance) {
        return anchor.method_5640(distance);
    }

    public <T> T get(EffectEntity entity, PalladiumProperty<T> property) {
        return property.get(entity);
    }

    public <T> void set(EffectEntity entity, PalladiumProperty<T> property, T value) {
        property.set(entity, value);
    }

    public boolean isPlaying(EffectEntity entity) {
        return this.get(entity, IS_DONE_PLAYING) == false;
    }

    public void stopPlaying(EffectEntity entity) {
        this.set(entity, IS_DONE_PLAYING, true);
    }

    @Environment(value=EnvType.CLIENT)
    public static void start(class_1297 anchor, EntityEffect entityEffect) {
        EffectEntity effectEntity = new EffectEntity(anchor.method_37908(), anchor, entityEffect);
        Objects.requireNonNull(class_310.method_1551().field_1687).method_2942(0, (class_1297)effectEntity);
    }

    @Environment(value=EnvType.CLIENT)
    public static void stop(class_1297 anchor, Predicate<EntityEffect> predicate) {
        anchor.method_37908().method_8333(anchor, anchor.method_5829().method_1014(2.0), entity -> entity instanceof EffectEntity && ((EffectEntity)((Object)entity)).getAnchorEntity() == anchor && predicate.test(((EffectEntity)entity).entityEffect)).forEach(class_1297::method_31472);
    }

    public static void stop(class_1297 anchor, EntityEffect entityEffectType) {
        EntityEffect.stop(anchor, (EntityEffect effect) -> effect == entityEffectType);
    }
}

