/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.fabric;

import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_2893;
import net.minecraft.class_55;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.PalladiumConfig;
import net.threetag.palladium.compat.geckolib.fabric.GeckoLibCompatImpl;
import net.threetag.palladium.compat.trinkets.fabric.TrinketsCompat;
import net.threetag.palladium.loot.LootTableModificationManager;
import net.threetag.palladium.world.PalladiumPlacedFeatures;
import net.threetag.palladiumcore.util.Platform;

public class PalladiumFabric
implements ModInitializer {
    public void onInitialize() {
        Palladium.init();
        ForgeConfigRegistry.INSTANCE.register("palladium", ModConfig.Type.CLIENT, (IConfigSpec)PalladiumConfig.Client.generateConfig());
        ForgeConfigRegistry.INSTANCE.register("palladium", ModConfig.Type.SERVER, (IConfigSpec)PalladiumConfig.Server.generateConfig());
        if (Platform.isModLoaded((String)"trinkets")) {
            TrinketsCompat.init();
        }
        if (Platform.isModLoaded((String)"geckolib")) {
            GeckoLibCompatImpl.init();
        }
        PalladiumFabric.registerEnergyHandlers();
        PalladiumFabric.registerEvents();
        PalladiumFabric.registerPlacedFeatures();
    }

    private static void registerEnergyHandlers() {
    }

    private static void registerEvents() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            LootTableModificationManager.Modification mod = LootTableModificationManager.getInstance().getFor(id);
            if (mod != null) {
                for (class_55 lootPool : mod.getLootPools()) {
                    tableBuilder.pool(lootPool);
                }
            }
        });
    }

    private static void registerPlacedFeatures() {
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13176, PalladiumPlacedFeatures.ORE_LEAD_UPPER);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13176, PalladiumPlacedFeatures.ORE_LEAD_MIDDLE);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13176, PalladiumPlacedFeatures.ORE_LEAD_SMALL);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13178, PalladiumPlacedFeatures.UNDERGROUND_VIBRANIUM_METEORITE);
    }
}

