/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3518;
import net.minecraft.class_6862;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonAttributeContainer;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.PlayerSlot;
import org.jetbrains.annotations.Nullable;

public class AddonShieldItem
extends class_1819
implements IAddonItem {
    private List<class_2561> tooltipLines;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private final AddonAttributeContainer attributeContainer = new AddonAttributeContainer();
    private boolean shouldRenderModel = true;
    public final int useDuration;
    public final Supplier<class_1856> repairIngredient;

    public AddonShieldItem(int useDuration, Supplier<class_1856> repairIngredient, class_1792.class_1793 properties) {
        super(properties);
        this.useDuration = useDuration;
        this.repairIngredient = repairIngredient;
    }

    public int method_7881(class_1799 stack) {
        return this.useDuration;
    }

    public boolean method_7878(class_1799 stack, class_1799 repairCandidate) {
        return this.repairIngredient.get().method_8093(repairCandidate);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        if (this.tooltipLines != null) {
            tooltipComponents.addAll(this.tooltipLines);
        }
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return this.attributeContainer.get(PlayerSlot.get(slot), (Multimap<class_1320, class_1322>)super.method_7844(slot));
    }

    @Override
    public AddonAttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    @Override
    public void setShouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
    }

    @Override
    public boolean shouldRenderModel() {
        return this.shouldRenderModel;
    }

    @Override
    public void setTooltip(List<class_2561> lines) {
        this.tooltipLines = lines;
    }

    @Override
    public void setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
    }

    @Override
    public IAddonItem.RenderLayerContainer getRenderLayerContainer() {
        return this.renderLayerContainer;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, class_1792.class_1793 properties) {
            int useDuration = class_3518.method_15282((JsonObject)json, (String)"use_duration", (int)72000);
            Supplier<class_1856> repairIngredient = () -> json.has("repair_ingredient") ? class_1856.method_52177((JsonElement)json.get("repair_ingredient")) : class_1856.field_9017;
            return new AddonShieldItem(useDuration, repairIngredient, properties);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Shield");
            builder.addProperty("use_duration", Integer.class).description("Amount of ticks the shield can be actively held for").fallback(72000).exampleJson((JsonElement)new JsonPrimitive((Number)72000));
            builder.addProperty("repair_ingredient", class_1856.class).description("The ingredient needed to repair the shield in an anvil. Can be null for making it non-repairable").fallback(null).exampleJson(class_1856.method_8106((class_6862)class_3489.field_15544).method_8089());
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("shield");
        }
    }
}

