/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.energy.EnergyHelper;
import net.threetag.palladium.energy.IEnergyStorage;
import net.threetag.palladium.item.AddonAttributeContainer;
import net.threetag.palladium.item.EnergyItem;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.Utils;
import org.jetbrains.annotations.Nullable;

public class FluxCapacitorItem
extends EnergyItem
implements IAddonItem {
    private static final int BAR_COLOR = class_3532.method_15353((float)0.9f, (float)0.1f, (float)0.0f);
    private List<class_2561> tooltipLines;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private final AddonAttributeContainer attributeContainer = new AddonAttributeContainer();
    private boolean shouldRenderModel = true;

    public FluxCapacitorItem(class_1792.class_1793 properties, int capacity, int maxInput, int maxOutput) {
        super(properties, capacity, maxInput, maxOutput);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        int stored = EnergyHelper.getEnergyStoredInItem(stack);
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.palladium.flux_capacitor.desc", (Object[])new Object[]{class_2561.method_43470((String)Utils.getFormattedNumber(stored)).method_27692(class_124.field_1065), class_2561.method_43470((String)Utils.getFormattedNumber(this.getEnergyCapacity(stack))).method_27692(class_124.field_1065)}).method_27692(class_124.field_1080));
        if (this.tooltipLines != null) {
            tooltipComponents.addAll(this.tooltipLines);
        }
    }

    public boolean method_31567(class_1799 stack) {
        Optional<IEnergyStorage> storage = EnergyHelper.getFromItemStack(stack);
        return storage.map(energyStorage -> energyStorage.getEnergyAmount() < energyStorage.getEnergyCapacity()).orElse(false);
    }

    public int method_31569(class_1799 stack) {
        Optional<IEnergyStorage> storage = EnergyHelper.getFromItemStack(stack);
        return storage.map(energyStorage -> Math.round(13.0f * (float)energyStorage.getEnergyAmount() / (float)energyStorage.getEnergyCapacity())).orElse(0);
    }

    public int method_31571(class_1799 stack) {
        return BAR_COLOR;
    }

    @Override
    public void setTooltip(List<class_2561> lines) {
        this.tooltipLines = lines;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return this.attributeContainer.get(PlayerSlot.get(slot), (Multimap<class_1320, class_1322>)super.method_7844(slot));
    }

    @Override
    public AddonAttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    @Override
    public void setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
    }

    @Override
    public IAddonItem.RenderLayerContainer getRenderLayerContainer() {
        return this.renderLayerContainer;
    }

    @Override
    public void setShouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
    }

    @Override
    public boolean shouldRenderModel() {
        return this.shouldRenderModel;
    }

    public class_1799 getEmptyInstance() {
        class_1799 filled = this.method_7854();
        filled.method_7948().method_10569("energy", 0);
        return filled;
    }

    public class_1799 getFullyChargedInstance() {
        class_1799 filled = this.method_7854();
        filled.method_7948().method_10569("energy", this.getEnergyCapacity(filled));
        return filled;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, class_1792.class_1793 properties) {
            int capacity = class_3518.method_15260((JsonObject)json, (String)"capacity");
            int maxInput = class_3518.method_15260((JsonObject)json, (String)"max_input");
            int maxOutput = class_3518.method_15260((JsonObject)json, (String)"max_output");
            if (capacity <= 0) {
                throw new JsonParseException("Energy capacity must be greater than 0");
            }
            if (maxInput < 0) {
                throw new JsonParseException("Energy max input can not be negative");
            }
            if (maxOutput < 0) {
                throw new JsonParseException("Energy max output can not be negative");
            }
            return new FluxCapacitorItem(properties, capacity, maxInput, maxOutput);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Flux Capacitor (Energy Containing Item)");
            builder.addProperty("capacity", Integer.class).description("Max amount of energy the item can hold").required().exampleJson((JsonElement)new JsonPrimitive((Number)500000));
            builder.addProperty("max_input", Integer.class).description("Maximum amount of energy the item can be inserted with during one insertion. Using 0 makes the item not accept any energy").required().exampleJson((JsonElement)new JsonPrimitive((Number)1000));
            builder.addProperty("max_output", Integer.class).description("Maximum amount of energy the item can extract with during one withdrawal. Using 0 makes the item not extract any energy").required().exampleJson((JsonElement)new JsonPrimitive((Number)1000));
        }

        @Override
        public class_2960 getId() {
            return new class_2960("palladium", "flux_capacitor");
        }
    }
}

