/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5270;
import net.minecraft.class_55;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class LootTableModificationManager
extends class_4309 {
    private static LootTableModificationManager INSTANCE;
    public static boolean OVERRIDE_FORGE_NAME_LOGIC;
    private static final Gson GSON;
    private Map<class_2960, Modification> modifications = ImmutableMap.of();

    public LootTableModificationManager() {
        super(GSON, "palladium/loot_table_modifications");
    }

    public static LootTableModificationManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LootTableModificationManager();
        }
        return INSTANCE;
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        object.forEach((id, element) -> {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)"top element");
                Modification modification = new Modification(GsonUtil.getAsResourceLocation(json, "target"));
                AtomicInteger i = new AtomicInteger(-1);
                GsonUtil.forEachInListOrPrimitive(json.get("add_pools"), poolJson -> {
                    i.getAndIncrement();
                    JsonObject jsonobject = class_3518.method_15295((JsonElement)poolJson, (String)"loot pool");
                    if (!jsonobject.has("name")) {
                        throw new JsonParseException("Loot Table Modification pool \"" + String.valueOf(id) + "\" Missing `name` entry for pool #" + i.get());
                    }
                    OVERRIDE_FORGE_NAME_LOGIC = true;
                    modification.addPool((class_55)GSON.fromJson(poolJson, class_55.class));
                    OVERRIDE_FORGE_NAME_LOGIC = false;
                });
                builder.put(id, (Object)modification);
            }
            catch (Exception e) {
                AddonPackLog.error("Parsing error loading loot table modification {}", id, e);
            }
        });
        this.modifications = builder.build();
        AddonPackLog.info("Loaded {} loot table modifications", this.modifications.size());
    }

    @Nullable
    public Modification getFor(class_2960 tableId) {
        for (Modification modification : this.modifications.values()) {
            if (!modification.getTargetTable().equals((Object)tableId)) continue;
            return modification;
        }
        return null;
    }

    static {
        OVERRIDE_FORGE_NAME_LOGIC = false;
        GSON = class_5270.method_27862().create();
    }

    public static class Modification {
        private final class_2960 targetTable;
        private final List<class_55> lootPools = new ArrayList<class_55>();
        private boolean applied = false;

        public Modification(class_2960 targetTable) {
            this.targetTable = targetTable;
        }

        public Modification addPool(class_55 lootPool) {
            this.lootPools.add(lootPool);
            return this;
        }

        public class_2960 getTargetTable() {
            return this.targetTable;
        }

        public List<class_55> getLootPools() {
            return this.lootPools;
        }

        public boolean markApplied() {
            if (this.applied) {
                return false;
            }
            this.applied = true;
            return true;
        }
    }
}

