/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.Collections;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessoryPlayerData;
import net.threetag.palladium.network.AbilityKeyPressedMessage;
import net.threetag.palladium.network.BuyAbilityUnlockMessage;
import net.threetag.palladium.network.NotifyMovementKeyListenerMessage;
import net.threetag.palladium.network.OpenAbilityBuyScreenMessage;
import net.threetag.palladium.network.RequestAbilityBuyScreenMessage;
import net.threetag.palladium.network.SetEnergyBarMessage;
import net.threetag.palladium.network.SetFlyingStateMessage;
import net.threetag.palladium.network.SyncAbilityEntryPropertyMessage;
import net.threetag.palladium.network.SyncAbilityStateMessage;
import net.threetag.palladium.network.SyncAccessoriesMessage;
import net.threetag.palladium.network.SyncFlightStateMessage;
import net.threetag.palladium.network.SyncPowersMessage;
import net.threetag.palladium.network.SyncPropertyMessage;
import net.threetag.palladium.network.ToggleAccessoryMessage;
import net.threetag.palladium.network.ToggleOpenableEquipmentMessage;
import net.threetag.palladium.network.UpdatePowersMessage;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladiumcore.network.MessageType;
import net.threetag.palladiumcore.network.NetworkManager;
import net.threetag.palladiumcore.util.DataSyncUtil;

public class PalladiumNetwork {
    public static final NetworkManager NETWORK = NetworkManager.create((class_2960)Palladium.id("main_channel"));
    public static final MessageType SYNC_POWERS = NETWORK.registerS2C("sync_powers", SyncPowersMessage::new);
    public static final MessageType UPDATE_POWERS = NETWORK.registerS2C("update_powers", UpdatePowersMessage::new);
    public static final MessageType SYNC_ABILITY_STATE = NETWORK.registerS2C("sync_ability_state", SyncAbilityStateMessage::new);
    public static final MessageType SYNC_PROPERTY = NETWORK.registerS2C("sync_property", SyncPropertyMessage::new);
    public static final MessageType SYNC_ABILITY_ENTRY_PROPERTY = NETWORK.registerS2C("sync_ability_entry_property", SyncAbilityEntryPropertyMessage::new);
    public static final MessageType ABILITY_KEY_PRESSED = NETWORK.registerC2S("ability_key_pressed", AbilityKeyPressedMessage::new);
    public static final MessageType NOTIFY_MOVEMENT_KEY_LISTENER = NETWORK.registerC2S("notify_jump_key_listener", NotifyMovementKeyListenerMessage::new);
    public static final MessageType SYNC_ACCESSORIES = NETWORK.registerS2C("sync_accessories", SyncAccessoriesMessage::new);
    public static final MessageType TOGGLE_ACCESSORY = NETWORK.registerC2S("toggle_accessory", ToggleAccessoryMessage::new);
    public static final MessageType REQUEST_ABILITY_BUY_SCREEN = NETWORK.registerC2S("request_ability_buy_screen", RequestAbilityBuyScreenMessage::new);
    public static final MessageType OPEN_ABILITY_BUY_SCREEN = NETWORK.registerS2C("open_ability_buy_screen", OpenAbilityBuyScreenMessage::new);
    public static final MessageType BUY_ABILITY_UNLOCK = NETWORK.registerC2S("buy_ability_unlock", BuyAbilityUnlockMessage::new);
    public static final MessageType SET_FLYING_STATE = NETWORK.registerC2S("set_flying_state", SetFlyingStateMessage::new);
    public static final MessageType SYNC_FLYING_STATE = NETWORK.registerS2C("sync_flying_state", SyncFlightStateMessage::new);
    public static final MessageType TOGGLE_OPENABLE_EQUIPMENT = NETWORK.registerC2S("toggle_openable_equipment", ToggleOpenableEquipmentMessage::new);
    public static final MessageType SET_ENERGY_BAR = NETWORK.registerS2C("set_energy_bar", SetEnergyBarMessage::new);

    public static void init() {
        DataSyncUtil.registerEntitySync((entity, consumer) -> {
            class_1309 livingEntity;
            Optional<PowerHandler> opt;
            if (entity instanceof class_1309 && (opt = PowerManager.getPowerHandler(livingEntity = (class_1309)entity)).isPresent()) {
                PowerHandler handler = opt.get();
                consumer.accept(new UpdatePowersMessage(livingEntity, Collections.emptyList(), handler.getPowerHolders().values().stream().map(h -> h.getPower().getId()).toList()));
                for (AbilityInstance entry : AbilityUtil.getEntries(livingEntity)) {
                    consumer.accept(entry.getSyncStateMessage(livingEntity));
                }
            }
        });
        DataSyncUtil.registerEntitySync((entity, consumer) -> {
            if (entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                Optional<AccessoryPlayerData> opt = Accessory.getPlayerData((class_1657)serverPlayer);
                opt.ifPresent(accessoryPlayerData -> consumer.accept(new SyncAccessoriesMessage(serverPlayer.method_5628(), accessoryPlayerData.accessories)));
            }
        });
        DataSyncUtil.registerEntitySync((entity, consumer) -> EntityPropertyHandler.getHandler(entity).ifPresent(properties -> properties.values().forEach((palladiumProperty, o) -> consumer.accept(new SyncPropertyMessage(entity.method_5628(), (PalladiumProperty<?>)palladiumProperty, o)))));
    }
}

