/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.threetag.palladium.client.screen.power.PowersScreen;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;

public class SyncAbilityEntryPropertyMessage
extends MessageS2C {
    private final int entityId;
    private final AbilityReference reference;
    private final String propertyKey;
    private final class_2487 tag;

    public SyncAbilityEntryPropertyMessage(int entityId, AbilityReference reference, String propertyKey, class_2487 tag) {
        this.entityId = entityId;
        this.reference = reference;
        this.propertyKey = propertyKey;
        this.tag = tag;
    }

    public SyncAbilityEntryPropertyMessage(class_2540 buf) {
        this.entityId = buf.readInt();
        this.reference = AbilityReference.fromBuffer(buf);
        this.propertyKey = buf.method_19772();
        this.tag = buf.method_10798();
    }

    public MessageType getType() {
        return PalladiumNetwork.SYNC_ABILITY_ENTRY_PROPERTY;
    }

    public void toBytes(class_2540 buf) {
        buf.writeInt(this.entityId);
        this.reference.toBuffer(buf);
        buf.method_10814(this.propertyKey);
        buf.method_10794(this.tag);
    }

    public void handle(MessageContext context) {
        this.handleClient();
    }

    @Environment(value=EnvType.CLIENT)
    public void handleClient() {
        PalladiumProperty<?> property;
        class_1309 livingEntity;
        AbilityInstance entry;
        class_638 level = Objects.requireNonNull(class_310.method_1551().field_1687);
        class_1297 entity = level.method_8469(this.entityId);
        if (entity instanceof class_1309 && (entry = this.reference.getEntry(livingEntity = (class_1309)entity)) != null && (property = entry.getPropertyManager().getPropertyByName(this.propertyKey)) != null) {
            entry.getPropertyManager().setRaw(property, property.fromNBT(this.tag.method_10580(property.getKey()), entry.getPropertyManager().getDefault(property)));
            class_437 class_4372 = class_310.method_1551().field_1755;
            if (class_4372 instanceof PowersScreen) {
                PowersScreen powers = (PowersScreen)class_4372;
                if (powers.selectedTab != null) {
                    powers.selectedTab.populate();
                }
            }
        }
    }
}

