/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;
import org.jetbrains.annotations.NotNull;

public class SyncFlightStateMessage
extends MessageS2C {
    private final int entityId;
    private final boolean flying;

    public SyncFlightStateMessage(int entityId, boolean flying) {
        this.entityId = entityId;
        this.flying = flying;
    }

    public SyncFlightStateMessage(class_2540 buf) {
        this.entityId = buf.readInt();
        this.flying = buf.readBoolean();
    }

    @NotNull
    public MessageType getType() {
        return PalladiumNetwork.SYNC_FLYING_STATE;
    }

    public void toBytes(class_2540 buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.flying);
    }

    public void handle(MessageContext context) {
        class_1297 entity = Objects.requireNonNull(class_310.method_1551().field_1687).method_8469(this.entityId);
        if (entity instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)entity;
            FlightHandler flight = extension.palladium$getFlightHandler();
            if (this.flying) {
                FlightHandler.FlightType flightType = FlightHandler.getAvailableFlightType((class_1309)((class_1657)entity));
                if (flightType.isNotNull()) {
                    flight.setFlightType(flightType);
                }
            } else {
                flight.setFlightType(FlightHandler.FlightType.NONE);
            }
            ((class_1657)entity).method_31549().field_7479 = false;
        }
    }
}

