/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.condition.ChatMessageCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.entity.PalladiumLivingEntityExtension;
import net.threetag.palladium.network.SyncPowersMessage;
import net.threetag.palladium.power.ClientPowerManager;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladiumcore.event.ChatEvents;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.LivingEntityEvents;
import net.threetag.palladiumcore.registry.ReloadListenerRegistry;
import net.threetag.palladiumcore.util.DataSyncUtil;
import org.jetbrains.annotations.Nullable;

public class PowerManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static PowerManager INSTANCE;
    public Map<class_2960, Power> byName = ImmutableMap.of();
    public static final List<String> CHECK_FOR_CHAT_MESSAGES;

    public static void init() {
        INSTANCE = new PowerManager();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_2960)Palladium.id("powers"), (class_3302)INSTANCE);
        LivingEntityEvents.TICK.register(entity -> PowerManager.getPowerHandler(entity).ifPresent(IPowerHandler::tick));
        DataSyncUtil.registerDataSync(consumer -> consumer.accept(new SyncPowersMessage(PowerManager.getInstance((boolean)true).byName)));
        ChatEvents.SERVER_SUBMITTED.register((player, rawMessage, message) -> {
            if (CHECK_FOR_CHAT_MESSAGES.contains(rawMessage.trim().toLowerCase(Locale.ROOT))) {
                for (AbilityInstance instance : AbilityUtil.getInstances((class_1309)player)) {
                    ChatMessageCondition chat;
                    for (Condition condition : instance.getConfiguration().getUnlockingConditions()) {
                        if (!(condition instanceof ChatMessageCondition)) continue;
                        chat = (ChatMessageCondition)condition;
                        if (!chat.chatMessage.trim().equalsIgnoreCase(rawMessage.trim())) continue;
                        chat.onChat((class_1309)player, instance);
                    }
                    for (Condition condition : instance.getConfiguration().getEnablingConditions()) {
                        if (!(condition instanceof ChatMessageCondition)) continue;
                        chat = (ChatMessageCondition)condition;
                        if (!chat.chatMessage.trim().equalsIgnoreCase(rawMessage.trim())) continue;
                        chat.onChat((class_1309)player, instance);
                    }
                }
            }
            return EventResult.pass();
        });
    }

    public PowerManager() {
        super(GSON, "palladium/powers");
    }

    public static PowerManager getInstance(boolean server) {
        return !server ? ClientPowerManager.INSTANCE : INSTANCE;
    }

    public static PowerManager getInstance(@Nullable class_1937 level) {
        return level != null && level.field_9236 ? ClientPowerManager.INSTANCE : INSTANCE;
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        CHECK_FOR_CHAT_MESSAGES.clear();
        object.forEach((id, json) -> {
            try {
                builder.put(id, (Object)Power.fromJSON(id, json.getAsJsonObject()));
            }
            catch (Exception e) {
                AddonPackLog.error("Parsing error loading power {}", id, e);
            }
        });
        this.byName.values().forEach(Power::invalidate);
        this.byName = builder.build();
        AddonPackLog.info("Loaded {} powers", this.byName.size());
    }

    public Power getPower(class_2960 id) {
        return this.byName.get(id);
    }

    public Set<class_2960> getIds() {
        return this.byName.keySet();
    }

    public Collection<Power> getPowers() {
        return this.byName.values();
    }

    public static Optional<PowerHandler> getPowerHandler(class_1309 entity) {
        if (entity instanceof PalladiumLivingEntityExtension) {
            PalladiumLivingEntityExtension ext = (PalladiumLivingEntityExtension)entity;
            return Optional.of(ext.palladium$getPowerHandler());
        }
        return Optional.empty();
    }

    static {
        CHECK_FOR_CHAT_MESSAGES = new ArrayList<String>();
    }
}

