/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.util.property.PalladiumProperties;

public class SuperpowerUtil {
    public static Collection<Power> getSuperpowers(class_1309 entity) {
        ArrayList<Power> powers = new ArrayList<Power>();
        for (class_2960 id : PalladiumProperties.SUPERPOWER_IDS.get((class_1297)entity)) {
            Power power = PowerManager.getInstance(entity.method_37908()).getPower(id);
            if (power == null) continue;
            powers.add(power);
        }
        return powers;
    }

    public static Collection<class_2960> getSuperpowerIds(class_1309 entity) {
        return PalladiumProperties.SUPERPOWER_IDS.get((class_1297)entity);
    }

    public static void setSuperpower(class_1309 entity, class_2960 powerId) {
        PalladiumProperties.SUPERPOWER_IDS.set((class_1297)entity, Collections.singletonList(powerId));
    }

    public static void setSuperpower(class_1309 entity, Power power) {
        SuperpowerUtil.setSuperpower(entity, power.getId());
    }

    public static void setSuperpowerIds(class_1309 entity, List<class_2960> powerIds) {
        PalladiumProperties.SUPERPOWER_IDS.set((class_1297)entity, powerIds);
    }

    public static void setSuperpowers(class_1309 entity, List<Power> powers) {
        SuperpowerUtil.setSuperpowerIds(entity, powers.stream().map(Power::getId).collect(Collectors.toList()));
    }

    public static void setSuperpowerIds(class_1309 entity, class_2960 ... powerIds) {
        PalladiumProperties.SUPERPOWER_IDS.set((class_1297)entity, Arrays.asList(powerIds));
    }

    public static void setSuperpower(class_1309 entity, Power ... powers) {
        SuperpowerUtil.setSuperpowerIds(entity, Arrays.stream(powers).map(Power::getId).collect(Collectors.toList()));
    }

    public static boolean hasSuperpower(class_1309 entity, class_2960 powerId) {
        return PalladiumProperties.SUPERPOWER_IDS.get((class_1297)entity).contains(powerId);
    }

    public static boolean hasSuperpower(class_1309 entity, Power power) {
        return SuperpowerUtil.hasSuperpower(entity, power.getId());
    }

    public static boolean addSuperpower(class_1309 entity, class_2960 powerId) {
        PowerManager powerManager = PowerManager.getInstance(entity.method_37908());
        if (powerManager.getPower(powerId) == null || SuperpowerUtil.hasSuperpower(entity, powerId)) {
            return false;
        }
        ArrayList<class_2960> powerIds = new ArrayList<class_2960>((Collection)PalladiumProperties.SUPERPOWER_IDS.get((class_1297)entity));
        powerIds.add(powerId);
        PalladiumProperties.SUPERPOWER_IDS.set((class_1297)entity, powerIds);
        return true;
    }

    public static boolean addSuperpower(class_1309 entity, Power power) {
        return SuperpowerUtil.addSuperpower(entity, power.getId());
    }

    public static boolean removeSuperpower(class_1309 entity, class_2960 powerId) {
        PowerManager powerManager = PowerManager.getInstance(entity.method_37908());
        if (powerManager.getPower(powerId) == null || !SuperpowerUtil.hasSuperpower(entity, powerId)) {
            return false;
        }
        ArrayList powerIds = new ArrayList(PalladiumProperties.SUPERPOWER_IDS.get((class_1297)entity));
        powerIds.remove(powerId);
        PalladiumProperties.SUPERPOWER_IDS.set((class_1297)entity, powerIds);
        return true;
    }

    public static boolean removeSuperpower(class_1309 entity, Power power) {
        return SuperpowerUtil.removeSuperpower(entity, power.getId());
    }

    public static int removeSuperpowers(class_1309 entity, Predicate<Power> predicate) {
        ArrayList<Power> toRemove = new ArrayList<Power>();
        for (Power superpower : SuperpowerUtil.getSuperpowers(entity)) {
            if (!predicate.test(superpower)) continue;
            toRemove.add(superpower);
        }
        int i = 0;
        for (Power power : toRemove) {
            if (!SuperpowerUtil.removeSuperpower(entity, power)) continue;
            ++i;
        }
        return i;
    }

    public static int removeSuperpowersByIds(class_1309 entity, Predicate<class_2960> predicate) {
        ArrayList<class_2960> toRemove = new ArrayList<class_2960>();
        for (class_2960 superpower : SuperpowerUtil.getSuperpowerIds(entity)) {
            if (!predicate.test(superpower)) continue;
            toRemove.add(superpower);
        }
        int i = 0;
        for (class_2960 power : toRemove) {
            if (!SuperpowerUtil.removeSuperpower(entity, power)) continue;
            ++i;
        }
        return i;
    }

    public static void removeAllSuperpowers(class_1309 entity) {
        PalladiumProperties.SUPERPOWER_IDS.set((class_1297)entity, Collections.emptyList());
    }
}

