/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.threetag.palladium.condition.AbilityWheelCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.CooldownType;
import net.threetag.palladium.network.SyncAbilityEntryPropertyMessage;
import net.threetag.palladium.network.SyncAbilityStateMessage;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladium.power.energybar.EnergyBarUsage;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;
import net.threetag.palladium.util.property.SyncType;
import org.jetbrains.annotations.Nullable;

public class AbilityInstance {
    private final AbilityConfiguration abilityConfiguration;
    private final IPowerHolder holder;
    private boolean unlocked = false;
    private boolean enabled = false;
    public boolean keyPressed = false;
    public int maxCooldown = 0;
    public int cooldown = 0;
    public int maxActivationTimer = 0;
    public int activationTimer = 0;
    private int lifetime = 0;
    private int prevEnabledTicks = 0;
    private int enabledTicks = 0;
    public String id;
    private final PropertyManager propertyManager = new PropertyManager().setListener(new PropertyManager.Listener(){

        @Override
        public <T> void onChanged(PalladiumProperty<T> property, T oldValue, T newValue) {
            AbilityInstance.this.syncProperty(property, AbilityInstance.this.holder.getEntity(), null);
        }
    });

    public AbilityInstance(AbilityConfiguration abilityConfiguration, IPowerHolder holder) {
        this.abilityConfiguration = abilityConfiguration;
        this.holder = holder;
        this.abilityConfiguration.getAbility().registerUniqueProperties(this.propertyManager);
        this.abilityConfiguration.getUnlockingConditions().forEach(condition -> condition.registerAbilityProperties(this, this.propertyManager));
        this.abilityConfiguration.getEnablingConditions().forEach(condition -> condition.registerAbilityProperties(this, this.propertyManager));
    }

    public AbilityConfiguration getConfiguration() {
        return this.abilityConfiguration;
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public IPowerHolder getHolder() {
        return this.holder;
    }

    public AbilityReference getReference() {
        return new AbilityReference(this.holder.getPower().getId(), this.id);
    }

    public void syncProperty(PalladiumProperty<?> property, class_1309 entity, @Nullable SyncType syncType) {
        if (!entity.method_37908().field_9236 && this.propertyManager.isRegistered(property)) {
            if (syncType == null) {
                syncType = property.getSyncType();
            }
            class_2487 tag = new class_2487();
            PalladiumProperty<?> property1 = property;
            tag.method_10566(property.getKey(), property1.toNBT(this.propertyManager.get(property)));
            if (syncType == SyncType.EVERYONE) {
                new SyncAbilityEntryPropertyMessage(entity.method_5628(), new AbilityReference(this.holder.getPower().getId(), this.abilityConfiguration.getId()), property.getKey(), tag).sendToDimension(entity.method_37908());
            } else if (syncType == SyncType.SELF && entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                new SyncAbilityEntryPropertyMessage(entity.method_5628(), new AbilityReference(this.holder.getPower().getId(), this.abilityConfiguration.getId()), property.getKey(), tag).send(serverPlayer);
            }
        }
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOnCooldown() {
        return this.getConfiguration().getCooldownType() == CooldownType.STATIC ? this.cooldown > 0 : this.cooldown < this.maxCooldown;
    }

    public int getEnabledTicks() {
        return this.enabledTicks;
    }

    public int getPrevEnabledTicks() {
        return this.prevEnabledTicks;
    }

    public void setClientState(class_1309 entity, IPowerHolder powerHolder, boolean unlocked, boolean enabled, int maxCooldown, int cooldown, int maxActivationTimer, int activationTimer) {
        this.unlocked = unlocked;
        this.maxCooldown = maxCooldown;
        this.cooldown = cooldown;
        this.maxActivationTimer = maxActivationTimer;
        this.activationTimer = activationTimer;
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (this.enabled) {
                this.abilityConfiguration.getAbility().firstTick(entity, this, powerHolder, this.isEnabled());
            } else {
                this.abilityConfiguration.getAbility().lastTick(entity, this, powerHolder, !this.isEnabled());
            }
        }
    }

    public void tick(class_1309 entity, IPowerHolder powerHolder) {
        CooldownType cooldownType;
        this.prevEnabledTicks = this.enabledTicks;
        if (!entity.method_37908().field_9236) {
            boolean enabled;
            if (this.lifetime == 0) {
                this.abilityConfiguration.getUnlockingConditions().forEach(condition -> condition.init(entity, this, this.propertyManager));
                this.abilityConfiguration.getEnablingConditions().forEach(condition -> condition.init(entity, this, this.propertyManager));
            }
            boolean unlocked = !entity.method_7325() && this.evaluateConditions(this.abilityConfiguration.getUnlockingConditions(), entity);
            boolean sync = false;
            if (this.unlocked != unlocked) {
                this.unlocked = unlocked;
                sync = true;
            }
            boolean bl = enabled = this.unlocked && this.evaluateConditions(this.abilityConfiguration.getEnablingConditions(), entity);
            if (this.enabled != enabled) {
                if (!this.enabled) {
                    this.enabled = true;
                    this.abilityConfiguration.getAbility().firstTick(entity, this, powerHolder, this.isEnabled());
                } else {
                    this.keyPressed = false;
                    this.abilityConfiguration.getAbility().lastTick(entity, this, powerHolder, this.isEnabled());
                    this.enabled = false;
                }
                sync = true;
            }
            if (sync || this.lifetime == 0) {
                this.syncState(entity);
            }
        }
        if (this.isEnabled()) {
            ++this.enabledTicks;
            for (EnergyBarUsage usage : this.getConfiguration().getEnergyBarUsages()) {
                usage.consume(this.holder);
            }
        } else if (this.enabledTicks > 0) {
            --this.enabledTicks;
        }
        if ((cooldownType = this.abilityConfiguration.getCooldownType()) == CooldownType.STATIC) {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        } else if (cooldownType == CooldownType.DYNAMIC) {
            if (this.isEnabled() && this.cooldown > 0) {
                --this.cooldown;
            } else if (!this.isEnabled() && this.cooldown < this.maxCooldown) {
                ++this.cooldown;
            }
        }
        if (this.activationTimer > 0) {
            --this.activationTimer;
        }
        ++this.lifetime;
        this.abilityConfiguration.getAbility().tick(entity, this, powerHolder, this.isEnabled());
    }

    private boolean evaluateConditions(List<Condition> conditions, class_1309 entity) {
        for (Condition condition : conditions) {
            if (condition.active(DataContext.forAbility(entity, this))) continue;
            return false;
        }
        return true;
    }

    public void syncState(class_1309 entity) {
        this.getSyncStateMessage(entity).sendToDimension(entity.method_37908());
    }

    public SyncAbilityStateMessage getSyncStateMessage(class_1309 entity) {
        return new SyncAbilityStateMessage(entity.method_5628(), this.getReference(), this.unlocked, this.enabled, this.maxCooldown, this.cooldown, this.maxActivationTimer, this.activationTimer);
    }

    public void startCooldown(class_1309 entity, int cooldown) {
        this.maxCooldown = this.cooldown = cooldown;
        this.syncState(entity);
    }

    public void startActivationTimer(class_1309 entity, int activationTimer) {
        this.maxActivationTimer = this.activationTimer = activationTimer;
        this.syncState(entity);
    }

    public void keyPressed(class_1309 entity, boolean pressed) {
        for (Condition condition : this.getConfiguration().getUnlockingConditions()) {
            if (!condition.needsKey() && !(condition instanceof AbilityWheelCondition)) continue;
            if (pressed) {
                condition.onKeyPressed(entity, this, this.holder.getPower(), this.holder);
            } else {
                condition.onKeyReleased(entity, this, this.holder.getPower(), this.holder);
            }
            return;
        }
        for (Condition condition : this.getConfiguration().getEnablingConditions()) {
            if (!condition.needsKey() && !(condition instanceof AbilityWheelCondition)) continue;
            if (pressed) {
                condition.onKeyPressed(entity, this, this.holder.getPower(), this.holder);
            } else {
                condition.onKeyReleased(entity, this, this.holder.getPower(), this.holder);
            }
            return;
        }
    }

    public PalladiumProperty<?> getEitherPropertyByKey(String key) {
        PalladiumProperty<?> property = this.propertyManager.getPropertyByName(key);
        return property != null ? property : this.abilityConfiguration.getPropertyManager().getPropertyByName(key);
    }

    public <T> T getProperty(PalladiumProperty<T> property) {
        return this.propertyManager.isRegistered(property) ? this.propertyManager.get(property) : this.abilityConfiguration.get(property);
    }

    public Object getPropertyByName(String key) {
        PalladiumProperty<?> property = this.getEitherPropertyByKey(key);
        return property != null ? this.getProperty(property) : null;
    }

    public <T> AbilityInstance setUniqueProperty(PalladiumProperty<T> property, T value) {
        this.propertyManager.set(property, value);
        return this;
    }

    public boolean setUniquePropertyByName(String key, Object value) {
        PalladiumProperty<?> property = this.getPropertyManager().getPropertyByName(key);
        if (property != null) {
            this.setUniqueProperty(property, PalladiumProperty.fixValues(property, value));
            return true;
        }
        return false;
    }

    public void fromNBT(class_2487 tag) {
        this.propertyManager.fromNBT(tag);
    }

    public class_2487 toNBT(boolean toDisk) {
        return this.propertyManager.toNBT(toDisk);
    }
}

