/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.client.screen.AbilityWheelRenderer;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringArrayProperty;
import net.threetag.palladium.util.property.SyncType;
import net.threetag.palladium.util.property.TextureReferenceProperty;
import net.threetag.palladiumcore.util.Platform;

public class AbilityWheelAbility
extends Ability {
    public static final PalladiumProperty<String[]> ABILITIES = new StringArrayProperty("abilities").configurable("List of ability keys to be used in the ability wheel.").sync(SyncType.SELF);
    public static final PalladiumProperty<TextureReference> TEXTURE = new TextureReferenceProperty("texture").configurable("Lets you use a custom texture for the wheel. If left null it will use the default rendering.").sync(SyncType.SELF);
    public static final PalladiumProperty<Boolean> DISABLE_MOUSE_SCROLLING = new BooleanProperty("disable_mouse_scrolling").configurable("Disables the ability to use the mouse wheel to scroll between the options.").sync(SyncType.SELF);
    public static final PalladiumProperty<Boolean> DISABLE_CENTER_ICON = new BooleanProperty("disable_center_icon").configurable("Disables the rendering of the icon in the middle of the wheel.").sync(SyncType.SELF);

    public AbilityWheelAbility() {
        this.withProperty(ABILITIES, new String[]{"example_ability"}).withProperty(TEXTURE, null).withProperty(DISABLE_MOUSE_SCROLLING, false).withProperty(DISABLE_CENTER_ICON, false);
    }

    @Override
    public void firstTick(class_1309 entity, AbilityInstance instance, IPowerHolder holder, boolean enabled) {
        if (Platform.isClient() && enabled) {
            this.setWheel(entity, instance, holder);
        }
    }

    @Override
    public void lastTick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (Platform.isClient()) {
            this.resetWheel(entity);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void setWheel(class_1309 entity, AbilityInstance instance, IPowerHolder holder) {
        if (entity == class_310.method_1551().field_1724) {
            ArrayList<AbilityInstance> list = new ArrayList<AbilityInstance>();
            for (String s : instance.getProperty(ABILITIES)) {
                AbilityInstance ability = holder.getAbilities().get(s);
                if (ability == null) continue;
                list.add(ability);
            }
            AbilityWheelRenderer.setWheel(new AbilityWheelRenderer.Wheel(list, instance.getProperty(TEXTURE), instance.getProperty(DISABLE_MOUSE_SCROLLING), instance.getProperty(DISABLE_CENTER_ICON)));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void resetWheel(class_1309 entity) {
        if (entity == class_310.method_1551().field_1724) {
            AbilityWheelRenderer.setWheel(null);
        }
    }
}

