/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.Comparator;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.AttributeProperty;
import net.threetag.palladium.util.property.DoubleProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.UUIDProperty;

public class AttributeModifierAbility
extends Ability {
    public static final PalladiumProperty<class_1320> ATTRIBUTE = new AttributeProperty("attribute").configurable("Determines which attribute should be modified. Possible attributes: " + AttributeModifierAbility.getAttributeList());
    public static final PalladiumProperty<Double> AMOUNT = new DoubleProperty("amount").configurable("The amount for the giving attribute modifier");
    public static final PalladiumProperty<Integer> OPERATION = new IntegerProperty("operation").configurable("The operation for the giving attribute modifier (More: https://minecraft.gamepedia.com/Attribute#Operations)");
    public static final PalladiumProperty<UUID> UUID = new UUIDProperty("uuid").configurable("Sets the unique identifier for this attribute modifier. If not specified it will generate a random one");

    public AttributeModifierAbility() {
        this.withProperty(ICON, new ItemIcon((class_1935)class_1802.field_8523));
        this.withProperty(ATTRIBUTE, class_5134.field_23724);
        this.withProperty(AMOUNT, 1.0);
        this.withProperty(OPERATION, 0);
        this.withProperty(UUID, java.util.UUID.fromString("498be4fb-af04-42f2-8948-e6ccdc0d99e1"));
    }

    @Override
    public void tick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            class_1320 attribute = entry.getProperty(ATTRIBUTE);
            class_1324 instance = entity.method_5996(attribute);
            if (instance == null || entity.method_37908().field_9236) {
                return;
            }
            UUID uuid = entry.getProperty(UUID);
            class_1322 modifier = instance.method_6199(uuid);
            if (modifier != null && (modifier.method_6186() != entry.getProperty(AMOUNT).doubleValue() || modifier.method_6182().method_6191() != entry.getProperty(OPERATION).intValue())) {
                instance.method_6200(uuid);
                modifier = null;
            }
            if (modifier == null) {
                modifier = new class_1322(uuid, entry.getConfiguration().getDisplayName().getString(), entry.getProperty(AMOUNT).doubleValue(), class_1322.class_1323.method_6190((int)entry.getProperty(OPERATION)));
                instance.method_26835(modifier);
            }
        } else {
            this.lastTick(entity, entry, holder, false);
        }
    }

    @Override
    public void lastTick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (entity.method_5996(entry.getProperty(ATTRIBUTE)) != null && entity.method_5996(entry.getProperty(ATTRIBUTE)).method_6199(entry.getProperty(UUID)) != null) {
            entity.method_5996(entry.getProperty(ATTRIBUTE)).method_6200(entry.getProperty(UUID));
        }
    }

    public static String getAttributeList() {
        return class_7923.field_41190.method_10235().stream().map(class_2960::toString).sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
    }

    @Override
    public String getDocumentationDescription() {
        return "Adds an attribute modifier to the entity while the ability is enabled.";
    }
}

