/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8110;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.TagKeyListProperty;

public class DamageImmunityAbility
extends Ability {
    public static final PalladiumProperty<List<class_6862<class_8110>>> DAMAGE_SOURCES = new TagKeyListProperty("damage_sources", class_7924.field_42534).configurable("Determines which damage sources have no effect on the entity based on a tag. Minecraft's builtin damage source tags: " + Arrays.toString(DamageImmunityAbility.getExampleTags().stream().map(t -> t.comp_327().toString()).toArray()));

    public DamageImmunityAbility() {
        this.withProperty(ICON, new ItemIcon((class_1935)class_1802.field_8574));
        this.withProperty(DAMAGE_SOURCES, Arrays.asList(class_8103.field_42253, class_8103.field_42250));
    }

    public static boolean isImmuneAgainst(AbilityInstance entry, class_1282 source) {
        if (!entry.isEnabled()) {
            return false;
        }
        for (class_6862<class_8110> tag : entry.getProperty(DAMAGE_SOURCES)) {
            if (!source.method_48789(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDocumentationDescription() {
        return "Makes the entity immune against certain damage source tags.";
    }

    public static List<class_6862<?>> getExampleTags() {
        Field[] allFields;
        ArrayList list = new ArrayList();
        for (Field field : allFields = class_8103.class.getDeclaredFields()) {
            try {
                Object object = field.get(null);
                if (!(object instanceof class_6862)) continue;
                class_6862 tag = (class_6862)object;
                list.add(tag);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }
}

