/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_6862;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.tags.PalladiumBlockTags;
import net.threetag.palladium.util.property.BlockTagProperty;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class IntangibilityAbility
extends Ability {
    public static final PalladiumProperty<Boolean> VERTICAL = new BooleanProperty("vertical").configurable("Makes the player vertically intangible aswell");
    public static final PalladiumProperty<class_6862<class_2248>> WHITELIST = new BlockTagProperty("whitelist").configurable("Tag which includes the block the player can phase through. Leave null for all blocks.");
    public static final PalladiumProperty<class_6862<class_2248>> BLACKLIST = new BlockTagProperty("blacklist").configurable("Tag which includes the block the player can phase through. Leave null for all blocks.");

    public IntangibilityAbility() {
        this.withProperty(VERTICAL, false).withProperty(WHITELIST, null).withProperty(BLACKLIST, PalladiumBlockTags.PREVENTS_INTANGIBILITY);
    }

    public static boolean canGoThrough(AbilityInstance entry, class_2680 state) {
        class_6862<class_2248> whitelist = entry.getProperty(WHITELIST);
        class_6862<class_2248> blacklist = entry.getProperty(BLACKLIST);
        if (whitelist != null) {
            if (blacklist != null) {
                return state.method_26164(whitelist) && !state.method_26164(blacklist);
            }
            return state.method_26164(whitelist);
        }
        if (blacklist != null) {
            return !state.method_26164(blacklist);
        }
        return true;
    }

    @Override
    public String getDocumentationDescription() {
        return "Makes the player go through blocks.";
    }
}

