/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.sound.AbilitySound;
import net.threetag.palladium.util.PlayerUtil;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.ResourceLocationProperty;
import net.threetag.palladiumcore.util.Platform;

public class PlaySoundAbility
extends Ability {
    public static final PalladiumProperty<class_2960> SOUND = new ResourceLocationProperty("sound").configurable("Sound ID that is being played");
    public static final PalladiumProperty<Float> VOLUME = new FloatProperty("volume").configurable("Volume for the played sound");
    public static final PalladiumProperty<Float> PITCH = new FloatProperty("pitch").configurable("Pitch for the played sound");
    public static final PalladiumProperty<Boolean> LOOPING = new BooleanProperty("looping").configurable("Whether or not the sound should loop during the time the ability is enabled");
    public static final PalladiumProperty<Boolean> PLAY_SELF = new BooleanProperty("play_self").configurable("Whether or not the sound should be played to just the player executing the ability, or to all players");
    public static final PalladiumProperty<Boolean> PLAY_OTHERS = new BooleanProperty("play_others").configurable("If 'play_self' is disabled, this determines whether or not the sound should be played to the players around the player executing the ability");

    public PlaySoundAbility() {
        this.withProperty(SOUND, new class_2960("item.elytra.flying")).withProperty(VOLUME, Float.valueOf(1.0f)).withProperty(PITCH, Float.valueOf(1.0f)).withProperty(LOOPING, false).withProperty(PLAY_SELF, false).withProperty(PLAY_OTHERS, false);
    }

    @Override
    public String getDocumentationDescription() {
        return "Plays a sound when being enabled.";
    }

    @Override
    public boolean isEffect() {
        return true;
    }

    @Override
    public void firstTick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            if (entry.getProperty(LOOPING).booleanValue()) {
                if (Platform.isClient() && entity.method_37908().field_9236) {
                    this.startSound(entity, entry);
                }
            } else if (!entity.method_37908().field_9236) {
                if (entry.getProperty(PLAY_SELF).booleanValue()) {
                    if (entity instanceof class_1657) {
                        class_1657 player2 = (class_1657)entity;
                        PlayerUtil.playSound(player2, entity.method_23317(), entity.method_23320(), entity.method_23321(), entry.getProperty(SOUND), entity.method_5634(), entry.getProperty(VOLUME).floatValue(), entry.getProperty(PITCH).floatValue());
                    }
                } else if (entry.getProperty(PLAY_OTHERS).booleanValue()) {
                    PlayerUtil.playSoundToAll(entity.method_37908(), entity.method_23317(), entity.method_23320(), entity.method_23321(), 100.0, entry.getProperty(SOUND), entity.method_5634(), entry.getProperty(VOLUME).floatValue(), entry.getProperty(PITCH).floatValue(), player -> player != entity);
                } else {
                    PlayerUtil.playSoundToAll(entity.method_37908(), entity.method_23317(), entity.method_23320(), entity.method_23321(), 100.0, entry.getProperty(SOUND), entity.method_5634(), entry.getProperty(VOLUME).floatValue(), entry.getProperty(PITCH).floatValue());
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void startSound(class_1309 entity, AbilityInstance entry) {
        boolean play = entry.getProperty(PLAY_SELF) != false ? entity == class_310.method_1551().field_1724 : (entry.getProperty(PLAY_OTHERS) != false ? entity != class_310.method_1551().field_1724 : true);
        if (play) {
            class_310.method_1551().method_1483().method_4873((class_1113)new AbilitySound(entry.getReference(), entity, entry.getProperty(SOUND), entity.method_5634(), entry.getProperty(VOLUME).floatValue(), entry.getProperty(PITCH).floatValue()));
        }
    }
}

