/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_742;
import net.threetag.palladium.client.renderer.entity.PlayerSkinFetcher;
import net.threetag.palladium.client.renderer.entity.PlayerSkinHandler;
import net.threetag.palladium.client.renderer.entity.PlayerSkinInfo;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;

public class PlayerSkinChangeAbility
extends Ability {
    public static final PalladiumProperty<String> USERNAME = new StringProperty("username").configurable("Name of the player you want to change into");
    public static final PalladiumProperty<String> PROPERTY = new StringProperty("property").configurable("In case you want to change the skin dynamically, you can specify the Palladium Property that contains a MC username here. This will override the 'username' property.");
    public static final PalladiumProperty<Integer> PRIORITY = new IntegerProperty("priority").configurable("Priority for the skin (in case multiple skin changes are applied, the one with the highest priority will be used)");

    public PlayerSkinChangeAbility() {
        this.withProperty(USERNAME, "Steve");
        this.withProperty(PROPERTY, "");
        this.withProperty(PRIORITY, 50);
    }

    public static String getPlayerName(AbilityInstance instance, class_1309 entity) {
        String property = instance.getProperty(PROPERTY);
        AtomicReference<String> nameRef = new AtomicReference<String>(instance.getProperty(USERNAME));
        if (property != null && !property.isEmpty()) {
            EntityPropertyHandler.getHandler((class_1297)entity).ifPresent(handler -> {
                Object patt1998$temp;
                PalladiumProperty<?> prop = handler.getPropertyByName(property);
                if (prop != null && (patt1998$temp = handler.get(prop)) instanceof String) {
                    String s = (String)patt1998$temp;
                    nameRef.set(s);
                }
            });
        }
        return nameRef.get();
    }

    @Override
    public boolean isEffect() {
        return true;
    }

    @Override
    public String getDocumentationDescription() {
        return "Allows you to change a player's skin to a MC profile one.";
    }

    @Environment(value=EnvType.CLIENT)
    public static class SkinProvider
    implements PlayerSkinHandler.ISkinProvider {
        @Override
        public PlayerSkinInfo getSkin(class_742 player, PlayerSkinInfo previousSkin, PlayerSkinInfo defaultSkin) {
            List<AbilityInstance> abilities = AbilityUtil.getEnabledInstances((class_1309)player, (Ability)Abilities.PLAYER_SKIN_CHANGE.get()).stream().filter(AbilityInstance::isEnabled).sorted((a1, a2) -> a2.getProperty(PRIORITY) - a1.getProperty(PRIORITY)).toList();
            if (!abilities.isEmpty()) {
                AbilityInstance ability = abilities.get(0);
                PlayerSkinInfo skin = PlayerSkinFetcher.getLoadedPlayerSkinInfo(PlayerSkinChangeAbility.getPlayerName(ability, (class_1309)player));
                return skin != null ? skin : previousSkin;
            }
            return previousSkin;
        }
    }
}

