/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PlayerSlotListProperty;
import net.threetag.palladium.util.property.SyncType;

public class RestrictSlotsAbility
extends Ability {
    public static final PalladiumProperty<List<PlayerSlot>> SLOTS = new PlayerSlotListProperty("slots").sync(SyncType.NONE).configurable("Slot(s) that will not be able to contain items anymore.");

    public RestrictSlotsAbility() {
        this.withProperty(SLOTS, Collections.singletonList(PlayerSlot.get(class_1304.field_6174)));
    }

    @Override
    public void tick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && !entity.method_37908().field_9236) {
            for (PlayerSlot slot : entry.getProperty(SLOTS)) {
                List<class_1799> items = slot.getItems(entity);
                slot.clear(entity);
                for (class_1799 item : items) {
                    if (item.method_7960()) continue;
                    this.drop(entity, item, slot);
                }
            }
        }
    }

    public void drop(class_1309 entity, class_1799 stack, PlayerSlot slot) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!player.method_31548().method_7394(stack)) {
                player.method_7328(stack, true);
            }
        } else {
            entity.method_5775(stack);
        }
    }

    public static boolean isRestricted(class_1309 entity, class_1304 slot) {
        for (AbilityInstance entry : AbilityUtil.getEnabledEntries(entity, (Ability)Abilities.RESTRICT_SLOTS.get())) {
            for (PlayerSlot playerSlot : entry.getProperty(SLOTS)) {
                if (playerSlot.getEquipmentSlot() != slot) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRestricted(class_1309 entity, String key) {
        for (AbilityInstance entry : AbilityUtil.getEnabledEntries(entity, (Ability)Abilities.RESTRICT_SLOTS.get())) {
            for (PlayerSlot playerSlot : entry.getProperty(SLOTS)) {
                if (!playerSlot.toString().equalsIgnoreCase(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDocumentationDescription() {
        return "Let's you restrict the slots that can be used by the player. It will drop the items if disabled while the player has items in the restricted slots.";
    }
}

